/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.document.json.JsonValue;
import com.couchbase.client.java.query.AbstractN1qlQuery;
import com.couchbase.client.java.query.N1qlParams;
import com.couchbase.client.java.query.Statement;

public class ParameterizedN1qlQuery
extends AbstractN1qlQuery {
    private final JsonValue statementParams;
    private final boolean positional;

    ParameterizedN1qlQuery(Statement statement, JsonArray positionalParams, N1qlParams params) {
        super(statement, params);
        this.statementParams = positionalParams;
        this.positional = true;
    }

    ParameterizedN1qlQuery(Statement statement, JsonObject namedParams, N1qlParams params) {
        super(statement, params);
        this.statementParams = namedParams;
        this.positional = false;
    }

    @Override
    protected String statementType() {
        return "statement";
    }

    @Override
    protected Object statementValue() {
        return this.statement().toString();
    }

    @Override
    public JsonValue statementParameters() {
        return this.statementParams;
    }

    public boolean isPositional() {
        return this.positional;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ParameterizedN1qlQuery{");
        sb.append("statement=").append(this.statement().toString());
        sb.append(", params=").append(this.statementParameters().toString());
        sb.append('}');
        return sb.toString();
    }
}

