/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonValue;
import com.couchbase.client.core.util.StorageSizeUnit;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Stability.Volatile
public final class StorageSize {
    private static final Pattern PATTERN = Pattern.compile("(\\d+)\\s*(.+)");
    private final long bytes;
    private final String formatted;

    private StorageSize(long bytes, String formatted) {
        if (bytes < 0L) {
            throw new IllegalArgumentException("Storage size cannot be negative");
        }
        this.bytes = bytes;
        this.formatted = Objects.requireNonNull(formatted);
    }

    public static StorageSize parse(String s) {
        Matcher m = PATTERN.matcher(s.trim());
        try {
            if (!m.matches()) {
                throw new IllegalArgumentException("Expected a whole number followed by a supported size unit (B, KiB, MiB, etc.)");
            }
            long value = Long.parseLong(m.group(1));
            StorageSizeUnit unit = StorageSizeUnit.parse(m.group(2));
            return StorageSize.of(value, unit);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unable to parse storage size '" + s + "' ; " + e.getMessage(), e);
        }
    }

    public static StorageSize ofBytes(long value) {
        return StorageSize.of(value, StorageSizeUnit.BYTES);
    }

    public static StorageSize ofKibibytes(long value) {
        return StorageSize.of(value, StorageSizeUnit.KIBIBYTES);
    }

    public static StorageSize ofMebibytes(long value) {
        return StorageSize.of(value, StorageSizeUnit.MEBIBYTES);
    }

    public static StorageSize ofGibibytes(long value) {
        return StorageSize.of(value, StorageSizeUnit.GIBIBYTES);
    }

    public static StorageSize ofTebibytes(long value) {
        return StorageSize.of(value, StorageSizeUnit.TEBIBYTES);
    }

    public static StorageSize ofPebibytes(long value) {
        return StorageSize.of(value, StorageSizeUnit.PEBIBYTES);
    }

    static StorageSize of(long value, StorageSizeUnit unit) {
        long bytes;
        try {
            bytes = Math.multiplyExact(value, unit.bytesPerUnit);
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException(value + " " + unit.abbreviation + " is larger than the limit of " + Long.MAX_VALUE + " bytes.");
        }
        StorageSizeUnit simplifiedUnit = StorageSizeUnit.largestExactUnit(bytes);
        long simplifiedValue = bytes / simplifiedUnit.bytesPerUnit;
        return new StorageSize(bytes, simplifiedValue + " " + simplifiedUnit.abbreviation);
    }

    public long bytes() {
        return this.bytes;
    }

    public int bytesAsInt() {
        return (int)this.requireInt().bytes;
    }

    @Stability.Internal
    public StorageSize requireInt() {
        if (this.bytes > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("This size must be less than 2 GiB, but got: " + this.format());
        }
        return this;
    }

    @JsonValue
    public String format() {
        return this.formatted;
    }

    public String toString() {
        return this.format();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageSize that = (StorageSize)o;
        return this.bytes == that.bytes;
    }

    public int hashCode() {
        return Long.hashCode(this.bytes);
    }
}

