/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import org.jspecify.annotations.Nullable;

@Stability.Internal
public class CbStrings {
    public static final String MIN_CODE_POINT_AS_STRING = CbStrings.codePointToString(0);
    public static final String MAX_CODE_POINT_AS_STRING = CbStrings.codePointToString(0x10FFFF);

    private CbStrings() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static String codePointToString(int codePoint) {
        return new String(Character.toChars(codePoint));
    }

    public static String nullToEmpty(@Nullable String s) {
        return s == null ? "" : s;
    }

    public static @Nullable String emptyToNull(@Nullable String s) {
        return CbStrings.isNullOrEmpty(s) ? null : s;
    }

    public static boolean isNullOrEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    public static String removeStart(String s, String removeMe) {
        return s.startsWith(removeMe) ? s.substring(removeMe.length()) : s;
    }

    public static String removeEnd(String s, String removeMe) {
        return s.endsWith(removeMe) ? s.substring(0, s.length() - removeMe.length()) : s;
    }
}

