/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.log;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.events.transaction.TransactionLogEvent;
import com.couchbase.client.core.util.CbThrowables;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreTransactionLogger {
    @Nullable
    private final EventBus eventBus;
    private final ConcurrentLinkedQueue<TransactionLogEvent> logs = new ConcurrentLinkedQueue();
    private final String transactionId;

    public CoreTransactionLogger(@Nullable EventBus eventBus, String primaryId) {
        this.eventBus = eventBus;
        this.transactionId = Objects.requireNonNull(primaryId);
    }

    public void debug(Throwable err) {
        this.log(err, Event.Severity.DEBUG);
    }

    public void debug(String secondaryId, Throwable err) {
        this.log(secondaryId, err, Event.Severity.DEBUG);
    }

    public void info(String secondaryId, Throwable err) {
        this.log(secondaryId, err, Event.Severity.INFO);
    }

    public void log(String secondaryId, Throwable err, Event.Severity level) {
        String st = CbThrowables.getStackTraceAsString(err);
        this.log(secondaryId, st, level);
    }

    public void log(Throwable err, Event.Severity level) {
        String st = CbThrowables.getStackTraceAsString(err);
        this.log(st, level);
    }

    public void logDefer(String secondaryId, String fmt, Event.Severity level, Object ... values) {
        TransactionLogEvent defer = new TransactionLogEvent(System.currentTimeMillis(), Thread.currentThread().getId(), Thread.currentThread().getName(), this.transactionId, secondaryId, fmt, values, level);
        this.logs.add(defer);
    }

    public void logDefer(String secondaryId, String fmt, Event.Severity level) {
        TransactionLogEvent defer = new TransactionLogEvent(System.currentTimeMillis(), Thread.currentThread().getId(), Thread.currentThread().getName(), this.transactionId, secondaryId, fmt, null, level);
        this.logs.add(defer);
    }

    public void log(String secondaryId, String value, Event.Severity level) {
        this.logDefer(secondaryId, value, level);
    }

    public void log(String value, Event.Severity level) {
        this.logDefer(null, value, level);
    }

    public void error(String secondaryId, String value) {
        this.log(secondaryId, value, Event.Severity.ERROR);
    }

    public void warn(String secondaryId, String value) {
        this.log(secondaryId, value, Event.Severity.WARN);
    }

    public void warn(String secondaryId, String fmt, Object ... values) {
        this.logDefer(secondaryId, fmt, Event.Severity.WARN, values);
    }

    public void info(String secondaryId, String value) {
        this.log(secondaryId, value, Event.Severity.INFO);
    }

    public void debug(String secondaryId, String value) {
        this.log(secondaryId, value, Event.Severity.DEBUG);
    }

    public void debug(String secondaryId, String fmt, Object ... values) {
        this.logDefer(secondaryId, fmt, Event.Severity.DEBUG, values);
    }

    public void trace(String secondaryId, String value) {
        this.log(secondaryId, value, Event.Severity.VERBOSE);
    }

    public void error(String value) {
        this.log(value, Event.Severity.ERROR);
    }

    public void warn(String value) {
        this.log(value, Event.Severity.WARN);
    }

    public void info(String value) {
        this.log(value, Event.Severity.INFO);
    }

    public void debug(String value) {
        this.log(value, Event.Severity.DEBUG);
    }

    public void trace(String value) {
        this.log(value, Event.Severity.VERBOSE);
    }

    public void trace(String secondaryId, String fmt, Object ... values) {
        this.logDefer(secondaryId, fmt, Event.Severity.VERBOSE, values);
    }

    public void info(String secondaryId, String fmt, Object ... values) {
        this.logDefer(secondaryId, fmt, Event.Severity.INFO, values);
    }

    public void info(String fmt, Object ... values) {
        this.logDefer(null, fmt, Event.Severity.INFO, values);
    }

    public List<TransactionLogEvent> logs() {
        return new ArrayList<TransactionLogEvent>(this.logs);
    }

    @Nullable
    public EventBus eventBus() {
        return this.eventBus;
    }
}

