/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.msg.BaseResponse;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.ResponseStatusDetails;
import com.couchbase.client.core.util.EnumLookupTable;

public class ObserveViaCasResponse
extends BaseResponse {
    private final long cas;
    private final ObserveStatus observeStatus;
    private final boolean active;
    private final ResponseStatusDetails statusDetails;

    public ObserveViaCasResponse(ResponseStatus status, long cas, ObserveStatus observeStatus, boolean active, ResponseStatusDetails statusDetails) {
        super(status);
        this.cas = cas;
        this.observeStatus = observeStatus;
        this.active = active;
        this.statusDetails = statusDetails;
    }

    public long cas() {
        return this.cas;
    }

    public ObserveStatus observeStatus() {
        return this.observeStatus;
    }

    public boolean active() {
        return this.active;
    }

    public ResponseStatusDetails statusDetails() {
        return this.statusDetails;
    }

    @Override
    public String toString() {
        return "ObserveViaCasResponse{cas=" + this.cas + ", observeStatus=" + (Object)((Object)this.observeStatus) + ", active=" + this.active + ", statusDetails=" + this.statusDetails + '}';
    }

    public static enum ObserveStatus {
        UNKNOWN(-16),
        UNINITIALIZED(-1),
        MODIFIED(-2),
        FOUND_PERSISTED(1),
        FOUND_NOT_PERSISTED(0),
        NOT_FOUND_PERSISTED(-128),
        NOT_FOUND_NOT_PERSISTED(-127);

        private final byte value;
        private static final EnumLookupTable<ObserveStatus> lookupTable;

        private ObserveStatus(byte b) {
            this.value = b;
        }

        public static ObserveStatus valueOf(byte b) {
            return lookupTable.getOrDefault(Byte.toUnsignedInt(b), UNINITIALIZED);
        }

        public byte value() {
            return this.value;
        }

        static {
            lookupTable = EnumLookupTable.create(ObserveStatus.class, e -> Byte.toUnsignedInt(e.value()));
        }
    }
}

