/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.TargetedRequest;
import com.couchbase.client.core.msg.kv.KvPingResponse;
import com.couchbase.client.core.msg.kv.NoopRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.topology.NodeIdentifier;
import java.time.Duration;
import java.util.Map;

public class KvPingRequest
extends NoopRequest
implements TargetedRequest {
    private final NodeIdentifier target;

    public KvPingRequest(Duration timeout, CoreContext ctx, RetryStrategy retryStrategy, CollectionIdentifier identifier, NodeIdentifier target) {
        super(timeout, ctx, retryStrategy, identifier);
        this.target = target;
    }

    @Override
    public KvPingResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        return new KvPingResponse(MemcacheProtocol.decodeStatus(response), ctx.channelId().asShortText());
    }

    @Override
    public NodeIdentifier target() {
        return this.target;
    }

    @Override
    public Map<String, Object> serviceContext() {
        Map<String, Object> ctx = super.serviceContext();
        if (this.target != null) {
            ctx.put("target", RedactableArgument.redactSystem(this.target));
        }
        return ctx;
    }

    @Override
    public String name() {
        return "ping";
    }
}

