/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.msg.kv.GetCollectionManifestResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import java.time.Duration;
import java.util.Optional;

public class GetCollectionManifestRequest
extends BaseKeyValueRequest<GetCollectionManifestResponse> {
    public GetCollectionManifestRequest(Duration timeout, CoreContext ctx, RetryStrategy retryStrategy, CollectionIdentifier collectionIdentifier) {
        super(timeout, ctx, retryStrategy, null, collectionIdentifier);
    }

    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        return MemcacheProtocol.request(alloc, MemcacheProtocol.Opcode.COLLECTIONS_GET_MANIFEST, MemcacheProtocol.noDatatype(), MemcacheProtocol.noPartition(), opaque, MemcacheProtocol.noCas(), MemcacheProtocol.noExtras(), MemcacheProtocol.noKey(), MemcacheProtocol.noBody());
    }

    @Override
    public GetCollectionManifestResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        ResponseStatus status = MemcacheProtocol.decodeStatus(response);
        Optional<String> manifest = status.success() ? Optional.of(MemcacheProtocol.bodyAsString(response)) : Optional.empty();
        return new GetCollectionManifestResponse(status, manifest);
    }

    @Override
    public boolean idempotent() {
        return true;
    }

    @Override
    public String name() {
        return "get_collection_manifest";
    }
}

