/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.kv;

import com.couchbase.client.core.deps.io.netty.channel.Channel;
import com.couchbase.client.core.io.netty.kv.ChannelAttributes;
import com.couchbase.client.core.util.NanoTimestamp;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;

public class ConnectTimings {
    private final List<Timing> timings = Collections.synchronizedList(new ArrayList());

    private ConnectTimings() {
    }

    public static void start(Channel channel, Class<?> clazz) {
        ConnectTimings timings = channel.attr(ChannelAttributes.CONNECT_TIMINGS_KEY).get();
        if (timings == null) {
            timings = new ConnectTimings();
            channel.attr(ChannelAttributes.CONNECT_TIMINGS_KEY).set(timings);
        }
        timings.timings.add(new Timing(clazz));
    }

    public static Optional<Duration> stop(Channel channel, Class<?> clazz, boolean timeout) {
        ConnectTimings timings = channel.attr(ChannelAttributes.CONNECT_TIMINGS_KEY).get();
        for (Timing timing : timings.timings) {
            if (!timing.clazz().equals(clazz)) continue;
            return Optional.of(timing.complete(timeout));
        }
        return Optional.empty();
    }

    public static void record(Channel channel, Class<?> clazz) {
        ConnectTimings.start(channel, clazz);
        ConnectTimings.stop(channel, clazz, false);
    }

    public static String toString(Channel channel) {
        String channelId = channel.id().asShortText();
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(channel.localAddress()).append(" -> ").append(channel.remoteAddress());
        sb.append(" (id: ").append(channelId).append(")");
        sb.append("]\n");
        for (Timing timing : ConnectTimings.timings(channel)) {
            sb.append(" -> ").append(timing.clazz.getSimpleName()).append(": ~").append(timing.isComplete() ? timing.latency().toMillis() : 0L).append("ms (complete=").append(timing.isComplete()).append(", timeout=").append(timing.timeout).append(")\n");
        }
        return sb.toString();
    }

    public static SortedMap<String, Duration> toMap(Channel channel) {
        TreeMap<String, Duration> timings = new TreeMap<String, Duration>();
        if (channel == null) {
            return timings;
        }
        for (Timing timing : ConnectTimings.timings(channel)) {
            timings.put(timing.clazz.getSimpleName(), timing.latency());
        }
        return timings;
    }

    private static List<Timing> timings(Channel channel) {
        ConnectTimings ct = channel.attr(ChannelAttributes.CONNECT_TIMINGS_KEY).get();
        return ct == null ? Collections.emptyList() : ct.timings;
    }

    static class Timing {
        private final NanoTimestamp start = NanoTimestamp.now();
        private final Class<?> clazz;
        private volatile NanoTimestamp end = NanoTimestamp.never();
        private volatile boolean timeout;

        Timing(Class<?> clazz) {
            this.clazz = clazz;
        }

        Class<?> clazz() {
            return this.clazz;
        }

        Duration latency() {
            if (!this.isComplete()) {
                throw new IllegalStateException("Incomplete Timing.");
            }
            return this.end.minus(this.start);
        }

        boolean isComplete() {
            return !this.end.isNever();
        }

        Duration complete(boolean timeout) {
            this.end = NanoTimestamp.now();
            this.timeout = timeout;
            return this.latency();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Timing timing = (Timing)o;
            if (this.start != timing.start) {
                return false;
            }
            if (this.end != timing.end) {
                return false;
            }
            if (this.timeout != timing.timeout) {
                return false;
            }
            return this.clazz != null ? this.clazz.equals(timing.clazz) : timing.clazz == null;
        }

        public int hashCode() {
            int result = this.start.hashCode();
            result = 31 * result + (this.clazz != null ? this.clazz.hashCode() : 0);
            result = 31 * result + this.end.hashCode();
            result = 31 * result + (this.timeout ? 1 : 0);
            return result;
        }
    }
}

