/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.ErrorCodeAndMessage;
import com.couchbase.client.core.error.context.ErrorContext;
import java.util.Collections;
import java.util.List;

@Stability.Internal
public class CoreErrorCodeAndMessageException
extends CouchbaseException {
    private final List<ErrorCodeAndMessage> errors;

    public CoreErrorCodeAndMessageException(List<ErrorCodeAndMessage> errors, ErrorContext errorContext) {
        super(errors.toString(), errorContext);
        this.errors = Collections.unmodifiableList(errors);
        if (errors.isEmpty()) {
            throw new IllegalArgumentException("errors list must not be empty");
        }
    }

    public List<ErrorCodeAndMessage> errors() {
        return this.errors;
    }

    public boolean retriable() {
        return this.errors.stream().allMatch(ErrorCodeAndMessage::retry);
    }

    public boolean hasCode(int code) {
        return this.errors.stream().anyMatch(it -> it.code() == code);
    }
}

