/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stability.Internal
public class VersionAndGitHash {
    private static final Logger log = LoggerFactory.getLogger(VersionAndGitHash.class);
    private final String version;
    private final String gitHash;
    public static final VersionAndGitHash UNKNOWN = new VersionAndGitHash("0.0.0", "");

    private VersionAndGitHash(String version, String gitHash) {
        this.version = Objects.requireNonNull(version);
        this.gitHash = Objects.requireNonNull(gitHash);
    }

    public String version() {
        return this.version;
    }

    public String gitHash() {
        return this.gitHash;
    }

    public String toString() {
        return this.version + " (" + this.gitHash + ")";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VersionAndGitHash from(Class<?> classInSamePackageAsVersionMetadata) {
        String resourceName = "version.properties";
        try (InputStream is = classInSamePackageAsVersionMetadata.getResourceAsStream(resourceName);){
            if (is == null) {
                log.warn("Resource '{}' not found in package {}", (Object)resourceName, (Object)classInSamePackageAsVersionMetadata.getPackage());
                VersionAndGitHash versionAndGitHash2 = UNKNOWN;
                return versionAndGitHash2;
            }
            Properties properties = new Properties();
            properties.load(is);
            String version = properties.getProperty("version");
            String gitHash = properties.getProperty("gitHash");
            VersionAndGitHash versionAndGitHash = new VersionAndGitHash(version == null ? "0.0.0" : version, gitHash == null ? "" : gitHash);
            return versionAndGitHash;
        }
        catch (IOException e) {
            log.warn("Failed to load '{}' from {}", new Object[]{resourceName, classInSamePackageAsVersionMetadata, e});
            return UNKNOWN;
        }
    }
}

