/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.topology.ClusterIdentifier;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

@Stability.Internal
public class RequestTracerDecorator
implements RequestTracer {
    private final RequestTracer wrapped;
    private final Supplier<ClusterIdentifier> clusterIdentSupplier;

    public RequestTracerDecorator(RequestTracer wrapped, Supplier<ClusterIdentifier> clusterIdentSupplier) {
        this.wrapped = Objects.requireNonNull(wrapped);
        this.clusterIdentSupplier = clusterIdentSupplier;
    }

    @Override
    public RequestSpan requestSpan(String name, RequestSpan parent) {
        RequestSpan span = this.wrapped.requestSpan(name, parent);
        span.lowCardinalityAttribute("db.system", "couchbase");
        ClusterIdentifier clusterIdent = this.clusterIdentSupplier.get();
        if (clusterIdent != null) {
            span.attribute("db.couchbase.cluster_name", clusterIdent.clusterName());
            span.attribute("db.couchbase.cluster_uuid", clusterIdent.clusterUuid());
        }
        return span;
    }

    @Override
    public Mono<Void> start() {
        return this.wrapped.start();
    }

    @Override
    public Mono<Void> stop(Duration timeout) {
        return this.wrapped.stop(timeout);
    }

    public String toString() {
        return this.wrapped.getClass().getSimpleName();
    }
}

