/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint;

import com.couchbase.client.core.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelPipeline;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpClientCodec;
import com.couchbase.client.core.endpoint.BaseEndpoint;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.endpoint.PipelineInitializer;
import com.couchbase.client.core.io.netty.NonChunkedHttpMessageHandler;
import com.couchbase.client.core.service.ServiceContext;
import com.couchbase.client.core.service.ServiceType;

public class BackupEndpoint
extends BaseEndpoint {
    public BackupEndpoint(ServiceContext ctx, String hostname, int port) {
        super(hostname, port, ctx.environment().ioEnvironment().backupEventLoopGroup().get(), ctx, ctx.environment().ioConfig().backupCircuitBreakerConfig(), ServiceType.BACKUP, false);
    }

    @Override
    protected PipelineInitializer pipelineInitializer() {
        return new BackupPipelineInitializer(this.context());
    }

    public static class BackupPipelineInitializer
    implements PipelineInitializer {
        private final EndpointContext endpointContext;

        public BackupPipelineInitializer(EndpointContext endpointContext) {
            this.endpointContext = endpointContext;
        }

        @Override
        public void init(BaseEndpoint endpoint, ChannelPipeline pipeline) {
            pipeline.addLast(new HttpClientCodec());
            pipeline.addLast(NonChunkedHttpMessageHandler.IDENTIFIER, (ChannelHandler)new NonChunkedHttpMessageHandler(endpoint, ServiceType.BACKUP){});
        }
    }
}

