/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.org.xbill.DNS.dnssec;

import com.couchbase.client.core.deps.org.xbill.DNS.DNSKEYRecord;
import com.couchbase.client.core.deps.org.xbill.DNS.DSRecord;
import com.couchbase.client.core.deps.org.xbill.DNS.Name;
import com.couchbase.client.core.deps.org.xbill.DNS.RRset;
import com.couchbase.client.core.deps.org.xbill.DNS.Record;
import com.couchbase.client.core.deps.org.xbill.DNS.dnssec.SRRset;
import com.couchbase.client.core.deps.org.xbill.DNS.dnssec.TrustAnchorStore;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class DefaultTrustAnchorStore
implements TrustAnchorStore {
    private final Map<String, RRset> map = new HashMap<String, RRset>();

    @Override
    public void store(RRset rrset) {
        String k;
        RRset previous;
        if (rrset.getType() != 43 && rrset.getType() != 48) {
            throw new IllegalArgumentException("Trust anchors can only be DS or DNSKEY records");
        }
        if (rrset.getType() == 48) {
            SRRset temp = new SRRset();
            for (Record r : rrset.rrs()) {
                DNSKEYRecord key = (DNSKEYRecord)r;
                DSRecord ds = new DSRecord(key.getName(), key.getDClass(), key.getTTL(), 4, key);
                temp.addRR(ds);
            }
            rrset = temp;
        }
        if ((previous = this.map.put(k = this.key(rrset.getName(), rrset.getDClass()), rrset)) != null) {
            previous.rrs().forEach(rrset::addRR);
        }
    }

    @Override
    public RRset find(Name name, int dclass) {
        while (name.labels() > 0) {
            String k = this.key(name, dclass);
            RRset r = this.lookup(k);
            if (r != null) {
                return r;
            }
            name = new Name(name, 1);
        }
        return null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Collection<RRset> items() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    private RRset lookup(String key) {
        return this.map.get(key);
    }

    private String key(Name n, int dclass) {
        return "T" + dclass + "/" + n.canonicalize();
    }
}

