/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.kv;

import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.CoreAsyncUtils;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import reactor.core.publisher.Mono;

@Stability.Internal
public final class CoreAsyncResponse<T> {
    private final CompletableFuture<T> future;
    private final Runnable cancellationTask;

    public CoreAsyncResponse(CompletableFuture<T> future, Runnable cancellationTask) {
        this.future = Objects.requireNonNull(future);
        this.cancellationTask = Objects.requireNonNull(cancellationTask);
    }

    public T toBlocking() {
        return CoreAsyncUtils.block(this.future);
    }

    public CompletableFuture<T> toFuture() {
        return this.future;
    }

    public CompletableFuture<Void> toFutureVoid() {
        return this.thenApply(it -> null);
    }

    public Mono<T> toMono() {
        return Reactor.wrap(this.future, this.cancellationTask);
    }

    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return this.toFuture().thenApply(fn);
    }

    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletableFuture<U>> fn) {
        return this.toFuture().thenCompose(fn);
    }

    public <U> CoreAsyncResponse<U> map(Function<? super T, ? extends U> fn) {
        return new CoreAsyncResponse<U>(this.thenApply(fn), this.cancellationTask);
    }

    public <U> CoreAsyncResponse<U> flatMap(Function<? super T, ? extends CoreAsyncResponse<U>> fn) {
        CompletableFuture<U> mapped = this.thenCompose(result -> {
            CoreAsyncResponse r = (CoreAsyncResponse)fn.apply(result);
            return r.toFuture();
        });
        return new CoreAsyncResponse<U>(mapped, this.cancellationTask);
    }
}

