/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreReadPreference;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.core.node.KeyValueLocator;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stability.Internal
public class NodeIndexCalculator {
    private final boolean[] allowedNodeIndexes;
    private final CouchbaseBucketConfig topology;
    private static final Logger logger = LoggerFactory.getLogger(NodeIndexCalculator.class);

    public NodeIndexCalculator(CoreReadPreference readPreference, CouchbaseBucketConfig topology, CoreContext coreContext) {
        boolean[] allowedNodeIndexesOut = new boolean[topology.nodes().size()];
        for (int nodeIndex = 0; nodeIndex < topology.portInfos().size(); ++nodeIndex) {
            boolean canUseNode = true;
            PortInfo node = topology.portInfos().get(nodeIndex);
            if (readPreference == CoreReadPreference.PREFERRED_SERVER_GROUP) {
                canUseNode = node.serverGroup() != null && node.serverGroup().equals(coreContext.environment().preferredServerGroup());
            }
            allowedNodeIndexesOut[nodeIndex] = canUseNode;
        }
        this.allowedNodeIndexes = allowedNodeIndexesOut;
        this.topology = topology;
    }

    public boolean canUseNode(String documentId, int replicaIndex, boolean isActive) {
        boolean useFastForward = false;
        int partitionId = KeyValueLocator.partitionForKey(documentId.getBytes(StandardCharsets.UTF_8), this.topology.numberOfPartitions());
        short nodeIndex = isActive ? this.topology.nodeIndexForActive(partitionId, useFastForward) : this.topology.nodeIndexForReplica(partitionId, replicaIndex, useFastForward);
        logger.trace("Checking whether doc can use node.  doc={} isActive={} replica={} pid={} ni={} allowed={}", new Object[]{documentId, isActive, replicaIndex, partitionId, (int)nodeIndex, this.allowedNodeIndexes});
        return this.check(nodeIndex);
    }

    public boolean canUseNodeForActive(String documentId) {
        return this.canUseNode(documentId, 0, true);
    }

    public boolean canUseNodeForReplica(String documentId, int replicaIndex) {
        return this.canUseNode(documentId, replicaIndex, false);
    }

    public boolean check(int nodeIndex) {
        if (nodeIndex < 0 || nodeIndex > this.allowedNodeIndexes.length) {
            return false;
        }
        return this.allowedNodeIndexes[nodeIndex];
    }
}

