/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.json.stream;

import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.json.stream.StreamWindow;
import java.nio.charset.StandardCharsets;

public class CopyingStreamWindow
implements StreamWindow {
    private final ByteBuf window;
    private long streamOffset;

    public CopyingStreamWindow(ByteBufAllocator allocator) {
        this.window = allocator.buffer();
    }

    @Override
    public void add(ByteBuf buf) {
        this.streamOffset += (long)buf.readableBytes();
        try {
            this.window.writeBytes(buf);
        }
        finally {
            buf.release();
        }
    }

    @Override
    public void releaseBefore(long releaseStreamOffset) {
        if (releaseStreamOffset <= 0L) {
            return;
        }
        int localOffset = this.toLocalOffset(releaseStreamOffset);
        this.window.skipBytes(localOffset);
        this.window.discardSomeReadBytes();
    }

    @Override
    public byte[] getBytes(long startStreamOffset, long endStreamOffset) {
        int localStartOffset = this.toLocalOffset(startStreamOffset);
        int localEndOffset = this.toLocalOffset(endStreamOffset);
        byte[] result = new byte[localEndOffset - localStartOffset];
        this.window.getBytes(this.window.readerIndex() + localStartOffset, result);
        return result;
    }

    private int toLocalOffset(long streamOffset) {
        return (int)(streamOffset - this.streamOffset + (long)this.window.readableBytes());
    }

    @Override
    public void close() {
        if (this.window.refCnt() > 0) {
            this.window.release();
        }
    }

    public String toString() {
        return this.window + ", streamOffset=" + this.streamOffset + ", content=`" + this.window.toString(StandardCharsets.UTF_8) + "`";
    }
}

