/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.config.BucketCapabilities;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterCapabilities;
import com.couchbase.client.core.config.ConfigVersion;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.config.MemcachedBucketConfig;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.topology.BucketCapability;
import com.couchbase.client.core.topology.BucketTopology;
import com.couchbase.client.core.topology.ClusterCapability;
import com.couchbase.client.core.topology.ClusterTopology;
import com.couchbase.client.core.topology.ClusterTopologyWithBucket;
import com.couchbase.client.core.topology.CouchbaseBucketTopology;
import com.couchbase.client.core.topology.HostAndServicePorts;
import com.couchbase.client.core.topology.MemcachedBucketTopology;
import com.couchbase.client.core.topology.TopologyRevision;
import com.couchbase.client.core.util.CbCollections;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Stability.Internal
public class LegacyConfigHelper {
    private LegacyConfigHelper() {
    }

    static List<PortInfo> getPortInfos(ClusterTopology topology) {
        return CbCollections.transform(topology.nodes(), it -> new PortInfo(LegacyConfigHelper.nonTlsPorts(topology, it), LegacyConfigHelper.tlsPorts(topology, it), Collections.emptyMap(), it.host(), it.id().toLegacy(), it.serverGroup()));
    }

    private static Map<ServiceType, Integer> tlsPorts(ClusterTopology topology, HostAndServicePorts node) {
        return topology.isTls() ? node.ports() : Collections.emptyMap();
    }

    private static Map<ServiceType, Integer> nonTlsPorts(ClusterTopology topology, HostAndServicePorts node) {
        return !topology.isTls() ? node.ports() : Collections.emptyMap();
    }

    static List<NodeInfo> getNodeInfosForBucket(ClusterTopologyWithBucket topology) {
        BucketTopology bucket = topology.bucket();
        List<HostAndServicePorts> allNodes = topology.nodes();
        if (!bucket.hasCapability(BucketCapability.COUCHAPI)) {
            allNodes = CbCollections.transform(allNodes, it -> it.without(ServiceType.VIEWS, new ServiceType[0]));
        }
        int numberOfBucketNodes = bucket.nodes().size();
        List<HostAndServicePorts> bucketNodes = allNodes.subList(0, numberOfBucketNodes);
        List<HostAndServicePorts> otherNodes = allNodes.subList(numberOfBucketNodes, allNodes.size());
        ArrayList<HostAndServicePorts> result = new ArrayList<HostAndServicePorts>(bucketNodes);
        for (HostAndServicePorts node : otherNodes) {
            result.add(node.without(ServiceType.KV, ServiceType.VIEWS).withKetamaAuthority(null));
        }
        return CbCollections.transform(result, it -> new NodeInfo(it.host(), LegacyConfigHelper.nonTlsPorts(topology, it), LegacyConfigHelper.tlsPorts(topology, it), it.ketamaAuthority(), it.id().toLegacy()));
    }

    static Map<ServiceType, Set<ClusterCapabilities>> getClusterCapabilities(ClusterTopology topology) {
        EnumMap<ServiceType, Set<ClusterCapabilities>> caps = new EnumMap<ServiceType, Set<ClusterCapabilities>>(ServiceType.class);
        for (ServiceType service : ServiceType.values()) {
            caps.put(service, new HashSet());
        }
        if (topology.hasCapability(ClusterCapability.N1QL_ENHANCED_PREPARED_STATEMENTS)) {
            ((Set)caps.get((Object)ServiceType.QUERY)).add(ClusterCapabilities.ENHANCED_PREPARED_STATEMENTS);
        }
        if (topology.hasCapability(ClusterCapability.SEARCH_VECTOR)) {
            ((Set)caps.get((Object)ServiceType.SEARCH)).add(ClusterCapabilities.VECTOR_SEARCH);
        }
        if (topology.hasCapability(ClusterCapability.SEARCH_SCOPED)) {
            ((Set)caps.get((Object)ServiceType.SEARCH)).add(ClusterCapabilities.SCOPED_SEARCH_INDEX);
        }
        return caps;
    }

    public static String uri(BucketTopology bucket) {
        return CoreHttpPath.formatPath("/pools/default/buckets/{}/?bucket_uuid={}", bucket.name(), bucket.uuid());
    }

    public static String streamingUri(BucketTopology bucket) {
        return CoreHttpPath.formatPath("/pools/default/bucketsStreaming/{}/?bucket_uuid={}", bucket.name(), bucket.uuid());
    }

    public static BucketConfig toLegacyBucketConfig(ClusterTopologyWithBucket cluster) {
        BucketTopology bucket = cluster.bucket();
        if (bucket instanceof MemcachedBucketTopology) {
            return new MemcachedBucketConfig(cluster, ((MemcachedBucketTopology)bucket).hashingStrategy());
        }
        if (bucket instanceof CouchbaseBucketTopology) {
            return new CouchbaseBucketConfig(cluster);
        }
        throw new IllegalArgumentException("Unsupported bucket type: " + cluster);
    }

    static Set<BucketCapabilities> toLegacy(Set<BucketCapability> capabilities) {
        EnumSet<BucketCapabilities> result = EnumSet.noneOf(BucketCapabilities.class);
        for (BucketCapability cap : capabilities) {
            try {
                result.add(BucketCapabilities.valueOf(cap.name()));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return result;
    }

    public static ConfigVersion toLegacy(TopologyRevision revision) {
        return new ConfigVersion(revision.epoch(), revision.rev());
    }
}

