/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.deps.io.netty.util.collection.IntObjectHashMap;
import com.couchbase.client.core.deps.io.netty.util.collection.IntObjectMap;
import com.couchbase.client.core.util.IntMap;
import java.util.Map;
import java.util.TreeMap;

class SparseIntMap<E>
implements IntMap<E> {
    private final IntObjectMap<E> indexToValue;

    public SparseIntMap(Map<Integer, E> indexToValue) {
        this.indexToValue = new IntObjectHashMap<E>(indexToValue.size());
        this.indexToValue.putAll(indexToValue);
    }

    @Override
    public E get(int key) {
        E result = this.indexToValue.get(key);
        if (result == null && key < 0) {
            throw new IllegalArgumentException("key must be non-negative, but got " + key);
        }
        return result;
    }

    public String toString() {
        return "SparseIntMap" + new TreeMap(this.indexToValue);
    }
}

