/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.components;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.transaction.forwards.ForwardCompatibility;
import java.util.Objects;
import java.util.Optional;

@Stability.Internal
public class TransactionLinks {
    private final Optional<String> atrId;
    private final Optional<String> atrBucketName;
    private final Optional<String> atrScopeName;
    private final Optional<String> atrCollectionName;
    private final Optional<String> stagedTransactionId;
    private final Optional<String> stagedAttemptId;
    private final Optional<byte[]> stagedContentJson;
    private final Optional<byte[]> stagedContentBinary;
    private final Optional<String> crc32OfStaging;
    private final Optional<String> casPreTxn;
    private final Optional<String> revidPreTxn;
    private final Optional<Long> exptimePreTxn;
    private final Optional<String> op;
    private final Optional<ForwardCompatibility> forwardCompatibility;
    private final Optional<String> stagedOperationId;
    private final Optional<Integer> stagedUserFlags;
    private final boolean isDeleted;

    public TransactionLinks(Optional<byte[]> stagedContentJson, Optional<byte[]> stagedContentBinary, Optional<String> atrId, Optional<String> atrBucketName, Optional<String> atrScopeName, Optional<String> atrCollectionName, Optional<String> stagedTransactionId, Optional<String> stagedAttemptId, Optional<String> casPreTxn, Optional<String> revidPreTxn, Optional<Long> exptimePreTxn, Optional<String> op, boolean isDeleted, Optional<String> crc32OfStaging, Optional<ForwardCompatibility> forwardCompatibility, Optional<String> stagedOperationId, Optional<Integer> stagedUserFlags) {
        this.stagedContentJson = Objects.requireNonNull(stagedContentJson);
        this.stagedContentBinary = Objects.requireNonNull(stagedContentBinary);
        this.atrId = Objects.requireNonNull(atrId);
        this.stagedTransactionId = Objects.requireNonNull(stagedTransactionId);
        this.stagedAttemptId = Objects.requireNonNull(stagedAttemptId);
        this.atrBucketName = Objects.requireNonNull(atrBucketName);
        this.atrScopeName = Objects.requireNonNull(atrScopeName);
        this.atrCollectionName = Objects.requireNonNull(atrCollectionName);
        this.casPreTxn = Objects.requireNonNull(casPreTxn);
        this.revidPreTxn = Objects.requireNonNull(revidPreTxn);
        this.exptimePreTxn = Objects.requireNonNull(exptimePreTxn);
        this.op = Objects.requireNonNull(op);
        this.isDeleted = isDeleted;
        this.crc32OfStaging = Objects.requireNonNull(crc32OfStaging);
        this.forwardCompatibility = Objects.requireNonNull(forwardCompatibility);
        this.stagedOperationId = Objects.requireNonNull(stagedOperationId);
        this.stagedUserFlags = stagedUserFlags;
    }

    public boolean isDocumentInTransaction() {
        return this.atrId.isPresent();
    }

    public boolean isDocumentBeingRemoved() {
        return this.op.isPresent() && this.op.get().equals("remove");
    }

    public boolean hasStagedWrite() {
        return this.stagedAttemptId.isPresent();
    }

    public Optional<String> atrId() {
        return this.atrId;
    }

    public Optional<String> stagedTransactionId() {
        return this.stagedTransactionId;
    }

    public Optional<String> stagedAttemptId() {
        return this.stagedAttemptId;
    }

    @Stability.Internal
    public Optional<byte[]> stagedContentJsonOrBinary() {
        if (this.stagedContentJson.isPresent()) {
            return this.stagedContentJson;
        }
        return this.stagedContentBinary;
    }

    @Stability.Internal
    public Optional<byte[]> stagedContentBinary() {
        return this.stagedContentBinary;
    }

    @Stability.Internal
    public Optional<byte[]> stagedContentJson() {
        return this.stagedContentJson;
    }

    public Optional<String> atrBucketName() {
        return this.atrBucketName;
    }

    public Optional<String> atrScopeName() {
        return this.atrScopeName;
    }

    public Optional<String> atrCollectionName() {
        return this.atrCollectionName;
    }

    public Optional<String> casPreTxn() {
        return this.casPreTxn;
    }

    public Optional<String> revidPreTxn() {
        return this.revidPreTxn;
    }

    public Optional<Long> exptimePreTxn() {
        return this.exptimePreTxn;
    }

    public Optional<String> op() {
        return this.op;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public Optional<String> crc32OfStaging() {
        return this.crc32OfStaging;
    }

    public Optional<ForwardCompatibility> forwardCompatibility() {
        return this.forwardCompatibility;
    }

    public Optional<String> stagedOperationId() {
        return this.stagedOperationId;
    }

    public Optional<Integer> stagedUserFlags() {
        return this.stagedUserFlags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TransactionLinks{");
        sb.append("atr=");
        sb.append(this.atrBucketName.orElse("none")).append('.');
        sb.append(this.atrScopeName.orElse("none")).append('.');
        sb.append(this.atrCollectionName.orElse("none")).append('.');
        sb.append(this.atrId.orElse("none")).append('.');
        sb.append(",txnId=").append(this.stagedTransactionId.orElse("none"));
        sb.append(",attemptId=").append(this.stagedAttemptId.orElse("none"));
        sb.append(",crc32Staging=").append(this.crc32OfStaging.orElse("none"));
        sb.append(",isDeleted=").append(this.isDeleted);
        this.stagedContentJson.ifPresent(s -> sb.append(",content=").append(((byte[])s).length).append("bytes"));
        sb.append(",op=").append(this.op.orElse("none"));
        sb.append(",fc=").append(this.forwardCompatibility.map(Object::toString).orElse("none"));
        sb.append(",opId=").append(this.stagedOperationId.orElse("none"));
        sb.append(",binary=").append(this.stagedContentBinary.isPresent());
        sb.append(",userFlags=").append(this.stagedUserFlags.map(Object::toString).orElse("none"));
        sb.append(",restore={");
        sb.append(this.casPreTxn.orElse("none"));
        sb.append(',');
        sb.append(this.revidPreTxn.orElse("none"));
        sb.append(',');
        sb.append(this.exptimePreTxn.orElse(-1L));
        sb.append("}}");
        return sb.toString();
    }

    public CollectionIdentifier collection() {
        return new CollectionIdentifier(this.atrBucketName.get(), this.atrScopeName, this.atrCollectionName);
    }
}

