/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.query.CoreQueryMetrics;
import com.couchbase.client.core.util.ProtostellarUtil;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.protostellar.query.v1.QueryResponse;
import java.time.Duration;

@Stability.Internal
public class ProtostellarCoreQueryMetrics
implements CoreQueryMetrics {
    private final QueryResponse.MetaData.Metrics metrics;

    public ProtostellarCoreQueryMetrics(QueryResponse.MetaData.Metrics metrics) {
        this.metrics = Validators.notNull(metrics, "metrics");
    }

    @Override
    public Duration elapsedTime() {
        return ProtostellarUtil.convert(this.metrics.getElapsedTime());
    }

    @Override
    public Duration executionTime() {
        return ProtostellarUtil.convert(this.metrics.getExecutionTime());
    }

    @Override
    public long sortCount() {
        return this.metrics.getSortCount();
    }

    @Override
    public long resultCount() {
        return this.metrics.getResultCount();
    }

    @Override
    public long resultSize() {
        return this.metrics.getResultSize();
    }

    @Override
    public long mutationCount() {
        return this.metrics.getMutationCount();
    }

    @Override
    public long errorCount() {
        return this.metrics.getErrorCount();
    }

    @Override
    public long warningCount() {
        return this.metrics.getWarningCount();
    }
}

