/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar.kv;

import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.CoreProtostellar;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreDurability;
import com.couchbase.client.core.api.kv.CoreExpiry;
import com.couchbase.client.core.api.kv.CoreKvBinaryParamValidators;
import com.couchbase.client.core.deps.com.google.protobuf.ByteString;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.protostellar.ProtostellarKeyValueRequest;
import com.couchbase.client.core.protostellar.ProtostellarRequest;
import com.couchbase.client.core.protostellar.kv.CoreProtostellarKeyValueRequests;
import com.couchbase.client.protostellar.kv.v1.AppendRequest;
import com.couchbase.client.protostellar.kv.v1.DecrementRequest;
import com.couchbase.client.protostellar.kv.v1.IncrementRequest;
import com.couchbase.client.protostellar.kv.v1.PrependRequest;
import java.time.Duration;
import java.util.Optional;

@Stability.Internal
public class CoreProtoStellarKvBinaryRequests {
    public static ProtostellarRequest<AppendRequest> appendRequest(CoreProtostellar core, String key, CoreKeyspace keyspace, CoreCommonOptions opts, byte[] content, long cas, CoreDurability durability) {
        CoreKvBinaryParamValidators.validateAppendPrependArgs(key, keyspace, opts, content, cas, durability);
        Duration timeout = CoreProtostellarUtil.kvDurableTimeout(opts.timeout(), durability, core);
        AppendRequest.Builder request = AppendRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key).setContent(ByteString.copyFrom(content));
        if (cas != 0L) {
            request.setCas(cas);
        }
        if (!durability.isNone()) {
            request.setDurabilityLevel(CoreProtostellarUtil.convert(durability));
        }
        return new ProtostellarKeyValueRequest<AppendRequest>(request.build(), core, keyspace, key, durability, "append", CoreProtostellarUtil.createSpan(core, "append", durability, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext(), 0L);
    }

    public static ProtostellarRequest<PrependRequest> prependRequest(CoreProtostellar core, String key, CoreKeyspace keyspace, CoreCommonOptions opts, byte[] content, long cas, CoreDurability durability) {
        CoreKvBinaryParamValidators.validateAppendPrependArgs(key, keyspace, opts, content, cas, durability);
        Duration timeout = CoreProtostellarUtil.kvDurableTimeout(opts.timeout(), durability, core);
        PrependRequest.Builder request = PrependRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key).setContent(ByteString.copyFrom(content));
        if (cas != 0L) {
            request.setCas(cas);
        }
        if (!durability.isNone()) {
            request.setDurabilityLevel(CoreProtostellarUtil.convert(durability));
        }
        return new ProtostellarKeyValueRequest<PrependRequest>(request.build(), core, keyspace, key, durability, "prepend", CoreProtostellarUtil.createSpan(core, "prepend", durability, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext(), 0L);
    }

    public static ProtostellarRequest<IncrementRequest> incrementRequest(CoreProtostellar core, String key, CoreKeyspace keyspace, CoreCommonOptions opts, CoreExpiry expiry, long delta, Optional<Long> initial, CoreDurability durability) {
        CoreKvBinaryParamValidators.validateIncrementDecrementArgs(key, keyspace, opts, expiry, delta, initial, durability);
        Duration timeout = CoreProtostellarUtil.kvDurableTimeout(opts.timeout(), durability, core);
        IncrementRequest.Builder request = IncrementRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key).setDelta(delta);
        initial.ifPresent(request::setInitial);
        expiry.when(absolute -> request.setExpiryTime(CoreProtostellarUtil.toExpiryTime(absolute)), relative -> request.setExpirySecs(CoreProtostellarUtil.toExpirySeconds(relative)), () -> request.setExpiryTime(CoreProtostellarKeyValueRequests.NO_EXPIRY));
        if (!durability.isNone()) {
            request.setDurabilityLevel(CoreProtostellarUtil.convert(durability));
        }
        return new ProtostellarKeyValueRequest<IncrementRequest>(request.build(), core, keyspace, key, durability, "increment", CoreProtostellarUtil.createSpan(core, "increment", durability, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext(), 0L);
    }

    public static ProtostellarRequest<DecrementRequest> decrementRequest(CoreProtostellar core, String key, CoreKeyspace keyspace, CoreCommonOptions opts, CoreExpiry expiry, long delta, Optional<Long> initial, CoreDurability durability) {
        CoreKvBinaryParamValidators.validateIncrementDecrementArgs(key, keyspace, opts, expiry, delta, initial, durability);
        Duration timeout = CoreProtostellarUtil.kvDurableTimeout(opts.timeout(), durability, core);
        DecrementRequest.Builder request = DecrementRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key).setDelta(delta);
        initial.ifPresent(request::setInitial);
        expiry.when(absolute -> request.setExpiryTime(CoreProtostellarUtil.toExpiryTime(absolute)), relative -> request.setExpirySecs(CoreProtostellarUtil.toExpirySeconds(relative)), () -> request.setExpiryTime(CoreProtostellarKeyValueRequests.NO_EXPIRY));
        if (!durability.isNone()) {
            request.setDurabilityLevel(CoreProtostellarUtil.convert(durability));
        }
        return new ProtostellarKeyValueRequest<DecrementRequest>(request.build(), core, keyspace, key, durability, "decrement", CoreProtostellarUtil.createSpan(core, "decrement", durability, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext(), 0L);
    }
}

