/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.kv;

import com.couchbase.client.core.util.Bytes;
import com.couchbase.client.core.util.Validators;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;

public class CoreRangeScanItem {
    private final int flags;
    private final Instant expiry;
    private final long seqno;
    private final long cas;
    private final String key;
    private final byte[] keyBytes;
    private final byte[] value;

    public static CoreRangeScanItem keyOnly(byte[] key) {
        return new CoreRangeScanItem(0, null, 0L, 0L, key, Bytes.EMPTY_BYTE_ARRAY);
    }

    public static CoreRangeScanItem keyAndBody(int flags, Instant expiry, long seqno, long cas, byte[] key, byte[] value) {
        return new CoreRangeScanItem(flags, expiry, seqno, cas, key, value);
    }

    protected CoreRangeScanItem(int flags, Instant expiry, long seqno, long cas, byte[] key, byte[] value) {
        this.flags = flags;
        this.expiry = expiry;
        this.seqno = seqno;
        this.cas = cas;
        this.keyBytes = key;
        this.key = new String(Validators.notNull(key, "RangeScanItem Key"), StandardCharsets.UTF_8);
        this.value = Validators.notNull(value, "RangeScanItem Value");
    }

    public int flags() {
        return this.flags;
    }

    public Instant expiry() {
        return this.expiry;
    }

    public long seqno() {
        return this.seqno;
    }

    public long cas() {
        return this.cas;
    }

    public String key() {
        return this.key;
    }

    public byte[] keyBytes() {
        return this.keyBytes;
    }

    public byte[] value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreRangeScanItem that = (CoreRangeScanItem)o;
        return this.flags == that.flags && this.seqno == that.seqno && this.cas == that.cas && Objects.equals(this.expiry, that.expiry) && Objects.equals(this.key, that.key) && Arrays.equals(this.keyBytes, that.keyBytes) && Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        int result = Objects.hash(this.flags, this.expiry, this.seqno, this.cas, this.key);
        result = 31 * result + Arrays.hashCode(this.keyBytes);
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    public String toString() {
        return "CoreRangeScanItem{flags=" + this.flags + ", expiry=" + this.expiry + ", seqno=" + this.seqno + ", cas=" + this.cas + ", key='" + this.key + '\'' + ", keyBytes=" + Arrays.toString(this.keyBytes) + ", value=" + Arrays.toString(this.value) + '}';
    }
}

