/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.io.netty.handler.codec.compression;

import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.core.deps.io.netty.handler.codec.ByteToMessageDecoder;
import com.couchbase.client.core.deps.io.netty.handler.codec.compression.DecompressionException;
import com.couchbase.client.core.deps.io.netty.handler.codec.compression.Zstd;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCounted;
import com.github.luben.zstd.ZstdInputStreamNoFinalizer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public final class ZstdDecoder
extends ByteToMessageDecoder {
    private final MutableByteBufInputStream inputStream;
    private ZstdInputStreamNoFinalizer zstdIs;
    private State currentState;

    public ZstdDecoder() {
        try {
            Zstd.ensureAvailability();
        }
        catch (Throwable throwable) {
            throw new ExceptionInInitializerError(throwable);
        }
        this.inputStream = new MutableByteBufInputStream();
        this.currentState = State.DECOMPRESS_DATA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        try {
            if (this.currentState == State.CORRUPTED) {
                in.skipBytes(in.readableBytes());
                return;
            }
            int compressedLength = in.readableBytes();
            this.inputStream.current = in;
            ReferenceCounted outBuffer = null;
            try {
                int w;
                do {
                    if (outBuffer == null) {
                        outBuffer = ctx.alloc().heapBuffer(compressedLength * 2);
                    }
                    while ((w = ((ByteBuf)outBuffer).writeBytes((InputStream)this.zstdIs, ((ByteBuf)outBuffer).writableBytes())) != -1 && ((ByteBuf)outBuffer).isWritable()) {
                    }
                    if (!((ByteBuf)outBuffer).isReadable()) continue;
                    out.add(outBuffer);
                    outBuffer = null;
                } while (w != -1);
            }
            finally {
                if (outBuffer != null) {
                    outBuffer.release();
                }
            }
        }
        catch (Exception e) {
            this.currentState = State.CORRUPTED;
            throw new DecompressionException(e);
        }
        finally {
            this.inputStream.current = null;
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.zstdIs = new ZstdInputStreamNoFinalizer((InputStream)this.inputStream);
        this.zstdIs.setContinuous(true);
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        try {
            ZstdDecoder.closeSilently((Closeable)this.zstdIs);
        }
        finally {
            super.handlerRemoved0(ctx);
        }
    }

    private static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static final class MutableByteBufInputStream
    extends InputStream {
        ByteBuf current;

        private MutableByteBufInputStream() {
        }

        @Override
        public int read() {
            if (this.current == null || !this.current.isReadable()) {
                return -1;
            }
            return this.current.readByte() & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) {
            int available = this.available();
            if (available == 0) {
                return -1;
            }
            len = Math.min(available, len);
            this.current.readBytes(b, off, len);
            return len;
        }

        @Override
        public int available() {
            return this.current == null ? 0 : this.current.readableBytes();
        }
    }

    private static enum State {
        DECOMPRESS_DATA,
        CORRUPTED;

    }
}

