/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config.refresher;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.events.config.BucketConfigRefreshFailedEvent;
import com.couchbase.client.core.config.ConfigurationProvider;
import com.couchbase.client.core.config.ProposedBucketConfigContext;
import com.couchbase.client.core.config.refresher.BucketRefresher;
import com.couchbase.client.core.error.ConfigException;
import com.couchbase.client.core.msg.manager.BucketConfigStreamingRequest;
import com.couchbase.client.core.retry.BestEffortRetryStrategy;
import com.couchbase.client.core.retry.reactor.Retry;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ClusterManagerBucketRefresher
implements BucketRefresher {
    private final ConfigurationProvider provider;
    private final Core core;
    private final Map<String, Disposable> registrations = new ConcurrentHashMap<String, Disposable>();
    private final EventBus eventBus;

    public ClusterManagerBucketRefresher(ConfigurationProvider provider, Core core) {
        this.provider = provider;
        this.core = core;
        this.eventBus = core.context().environment().eventBus();
    }

    @Override
    public synchronized Mono<Void> register(String name) {
        if (this.registrations.containsKey(name)) {
            return Mono.empty();
        }
        return Mono.defer(() -> {
            Disposable registration = this.registerStream(this.core.context(), name);
            this.registrations.put(name, registration);
            return Mono.empty();
        });
    }

    private Disposable registerStream(CoreContext ctx, String name) {
        return Mono.defer(() -> {
            BucketConfigStreamingRequest request = new BucketConfigStreamingRequest(ctx.environment().timeoutConfig().managementTimeout(), ctx, BestEffortRetryStrategy.INSTANCE, name, ctx.authenticator());
            this.core.send(request);
            return Reactor.wrap(request, request.response(), true);
        }).flux().flatMap(res -> {
            if (res.status().success()) {
                return res.configs().map(config -> new ProposedBucketConfigContext(name, (String)config, res.address()));
            }
            this.eventBus.publish(new BucketConfigRefreshFailedEvent(this.core.context(), BucketConfigRefreshFailedEvent.RefresherType.MANAGER, BucketConfigRefreshFailedEvent.Reason.INDIVIDUAL_REQUEST_FAILED, Optional.of(res)));
            return Flux.error((Throwable)new ConfigException());
        }).doOnError(e -> this.eventBus.publish(new BucketConfigRefreshFailedEvent(this.core.context(), BucketConfigRefreshFailedEvent.RefresherType.MANAGER, BucketConfigRefreshFailedEvent.Reason.STREAM_FAILED, Optional.of(e)))).doOnComplete(() -> {
            this.eventBus.publish(new BucketConfigRefreshFailedEvent(this.core.context(), BucketConfigRefreshFailedEvent.RefresherType.MANAGER, BucketConfigRefreshFailedEvent.Reason.STREAM_CLOSED, Optional.empty()));
            throw new ConfigException();
        }).retryWhen(Retry.any().exponentialBackoff(Duration.ofMillis(32L), Duration.ofMillis(4096L)).toReactorRetry()).subscribe(this.provider::proposeBucketConfig);
    }

    @Override
    public synchronized Mono<Void> deregister(String name) {
        return Mono.defer(() -> {
            Disposable registration = this.registrations.get(name);
            if (registration != null && !registration.isDisposed()) {
                registration.dispose();
            }
            return Mono.empty();
        });
    }

    @Override
    public synchronized Mono<Void> shutdown() {
        return Mono.defer(() -> {
            for (Disposable registration : this.registrations.values()) {
                if (registration.isDisposed()) continue;
                registration.dispose();
            }
            this.registrations.clear();
            return Mono.empty();
        });
    }

    @Override
    public void markTainted(String name) {
    }

    @Override
    public void markUntainted(String name) {
    }

    @Override
    public Set<String> registered() {
        return this.registrations.keySet();
    }
}

