/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.queries;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.api.search.queries.CoreMatchNoneQuery;
import com.couchbase.client.core.api.search.vector.CoreVectorSearch;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.json.Mapper;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreSearchRequest {
    @Nullable
    public final CoreSearchQuery searchQuery;
    @Nullable
    public final CoreVectorSearch vectorSearch;

    public CoreSearchRequest(@Nullable CoreSearchQuery searchQuery, @Nullable CoreVectorSearch vectorSearch) {
        if (searchQuery == null && vectorSearch == null) {
            throw new InvalidArgumentException("At least one of searchQuery and vectorSearch must be specified", null, null);
        }
        this.searchQuery = searchQuery == null ? new CoreMatchNoneQuery(null) : searchQuery;
        this.vectorSearch = vectorSearch;
    }

    public ObjectNode toJson() {
        ObjectNode topLevel = Mapper.createObjectNode();
        if (this.searchQuery != null) {
            ObjectNode query = Mapper.createObjectNode();
            this.searchQuery.injectParamsAndBoost(query);
            topLevel.put("query", query);
        }
        if (this.vectorSearch != null) {
            this.vectorSearch.injectTopLevel(topLevel);
        }
        return topLevel;
    }
}

