/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.getmulti;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.transaction.CoreTransactionGetMultiResult;
import com.couchbase.client.core.transaction.CoreTransactionOptionalGetMultiResult;
import com.couchbase.client.core.transaction.components.CoreTransactionGetMultiSpec;
import com.couchbase.client.core.transaction.getmulti.CoreGetMultiOptions;
import com.couchbase.client.core.transaction.getmulti.CoreGetMultiPhase;
import com.couchbase.client.core.transaction.getmulti.CoreGetMultiSignal;
import com.couchbase.client.core.transaction.getmulti.CoreGetMultiSignalAndReason;
import com.couchbase.client.core.transaction.log.CoreTransactionLogger;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@Stability.Internal
public class CoreGetMultiState {
    public static final Duration DEFAULT_INITIAL_DOC_FETCH_BOUND = Duration.ofMillis(2500L);
    public static final Duration DEFAULT_READ_SKEW_BOUND = Duration.ofMillis(100L);
    public static final List<CoreTransactionGetMultiSpec> EMPTY_GET_MULTI_SPEC_LIST = new ArrayList<CoreTransactionGetMultiSpec>();
    public static final List<CoreTransactionOptionalGetMultiResult> EMPTY_GET_MULTI_RESULT_LIST = new ArrayList<CoreTransactionOptionalGetMultiResult>();
    public final List<CoreTransactionGetMultiSpec> originalSpecs;
    public final CoreGetMultiOptions options;
    private List<CoreTransactionGetMultiSpec> toFetch;
    private List<CoreTransactionOptionalGetMultiResult> alreadyFetched = EMPTY_GET_MULTI_RESULT_LIST;
    private CoreGetMultiPhase phase = CoreGetMultiPhase.FIRST_DOC_FETCH;
    public Instant deadline;
    public final boolean replicasFromPreferredServerGroup;

    public String toString() {
        return "GetMultiState{originalSpecs=" + this.originalSpecs.size() + ", toFetch=" + this.toFetch.size() + ", alreadyFetched=" + this.alreadyFetched.size() + ", mode=" + (Object)((Object)this.phase) + ", deadline=" + this.deadline + ", mode=" + (Object)((Object)this.options.mode) + ", replicasFromPreferredServerGroup=" + this.replicasFromPreferredServerGroup + '}';
    }

    public CoreGetMultiState(List<CoreTransactionGetMultiSpec> toFetch, Instant deadline, boolean replicasFromPreferredServerGroup, CoreGetMultiOptions options) {
        this.originalSpecs = new ArrayList<CoreTransactionGetMultiSpec>((Collection)Objects.requireNonNull(toFetch));
        this.toFetch = this.originalSpecs;
        this.deadline = Objects.requireNonNull(deadline);
        this.replicasFromPreferredServerGroup = replicasFromPreferredServerGroup;
        this.options = Objects.requireNonNull(options);
    }

    public boolean deadlineExceededSoon() {
        return Instant.now().isAfter(this.deadline.minusMillis(5L));
    }

    public List<CoreTransactionGetMultiSpec> toFetch() {
        return this.toFetch;
    }

    public CoreGetMultiSignalAndReason update(CoreTransactionLogger logger, List<CoreTransactionGetMultiSpec> toFetch, List<CoreTransactionOptionalGetMultiResult> alreadyFetched, CoreGetMultiPhase mode, Instant deadline) {
        this.toFetch = toFetch;
        this.alreadyFetched = alreadyFetched;
        this.phase = mode;
        this.deadline = deadline;
        logger.info("<>", "Updated state to {}", this);
        return this.assertValidState();
    }

    public List<CoreTransactionOptionalGetMultiResult> alreadyFetched() {
        return this.alreadyFetched;
    }

    public CoreGetMultiPhase phase() {
        return this.phase;
    }

    public List<CoreTransactionGetMultiResult> fetchedAndPresent() {
        return this.alreadyFetched.stream().filter(v -> v.internal.isPresent()).map(CoreTransactionOptionalGetMultiResult::get).collect(Collectors.toList());
    }

    public CoreGetMultiSignalAndReason assertInReadSkewResolutionState() {
        List<CoreTransactionGetMultiResult> fetchedAndPresent = this.fetchedAndPresent();
        Set transactionIdsInvolved = fetchedAndPresent.stream().filter(v -> Objects.requireNonNull(v.internal.links()).isDocumentInTransaction()).map(v -> Objects.requireNonNull(v.internal.links()).stagedTransactionId().get()).collect(Collectors.toSet());
        if (fetchedAndPresent.size() < 2) {
            return new CoreGetMultiSignalAndReason(CoreGetMultiSignal.RESET_AND_RETRY, "getMulti internal bug detected - have less than 2 in " + fetchedAndPresent);
        }
        if (transactionIdsInvolved.size() != 1) {
            return new CoreGetMultiSignalAndReason(CoreGetMultiSignal.RESET_AND_RETRY, "getMulti internal bug detected - have more than 1 T1 unexpected " + transactionIdsInvolved);
        }
        return CoreGetMultiSignalAndReason.CONTINUE;
    }

    public CoreGetMultiSignalAndReason assertValidState() {
        if (this.alreadyFetched.size() + this.toFetch.size() != this.originalSpecs.size()) {
            return new CoreGetMultiSignalAndReason(CoreGetMultiSignal.RESET_AND_RETRY, "getMulti internal bug detected - alreadyFetched+toFetch!=originalSpecs " + this);
        }
        return CoreGetMultiSignalAndReason.CONTINUE;
    }

    public void reset(CoreTransactionLogger logger) {
        this.update(logger, this.originalSpecs, EMPTY_GET_MULTI_RESULT_LIST, this.phase == CoreGetMultiPhase.FIRST_DOC_FETCH ? CoreGetMultiPhase.FIRST_DOC_FETCH : CoreGetMultiPhase.SUBSEQUENT_TO_FIRST_DOC_FETCH, this.deadline);
    }
}

