/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.forwards;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.transaction.forwards.CoreTransactionsExtension;
import com.couchbase.client.core.util.CbCollections;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

@Stability.Internal
public class CoreTransactionsSupportedExtensions {
    public static final CoreTransactionsSupportedExtensions NONE = CoreTransactionsSupportedExtensions.from(new CoreTransactionsExtension[0]);
    public static final CoreTransactionsSupportedExtensions ALL = CoreTransactionsSupportedExtensions.from(CoreTransactionsExtension.values());
    private static final Set<CoreTransactionsExtension> ALL_2_1 = CbCollections.setOf(CoreTransactionsExtension.EXT_TRANSACTION_ID, CoreTransactionsExtension.EXT_TIME_OPT_UNSTAGING, CoreTransactionsExtension.EXT_BINARY_METADATA, CoreTransactionsExtension.EXT_CUSTOM_METADATA_COLLECTION, CoreTransactionsExtension.EXT_QUERY, CoreTransactionsExtension.EXT_STORE_DURABILITY, CoreTransactionsExtension.BF_CBD_3838, CoreTransactionsExtension.BF_CBD_3787, CoreTransactionsExtension.BF_CBD_3705, CoreTransactionsExtension.BF_CBD_3794, CoreTransactionsExtension.EXT_REMOVE_COMPLETED, CoreTransactionsExtension.EXT_ALL_KV_COMBINATIONS, CoreTransactionsExtension.EXT_UNKNOWN_ATR_STATES, CoreTransactionsExtension.BF_CBD_3791, CoreTransactionsExtension.EXT_SINGLE_QUERY);
    public final Set<CoreTransactionsExtension> extensions;
    private final Set<String> extensionIds;
    private final int protocolMajor = 2;
    private final int protocolMinor;

    private CoreTransactionsSupportedExtensions(Iterable<CoreTransactionsExtension> extensions) {
        this.extensions = Collections.unmodifiableSet(CbCollections.newEnumSet(CoreTransactionsExtension.class, extensions));
        this.extensionIds = Collections.unmodifiableSet(this.extensions.stream().map(CoreTransactionsExtension::value).collect(Collectors.toSet()));
        this.protocolMinor = this.extensions.equals(ALL_2_1) ? 1 : 0;
    }

    public int protocolMajor() {
        return 2;
    }

    public int protocolMinor() {
        return this.protocolMinor;
    }

    public static CoreTransactionsSupportedExtensions from(CoreTransactionsExtension ... extensions) {
        return new CoreTransactionsSupportedExtensions(Arrays.asList(extensions));
    }

    public boolean has(String extensionId) {
        return this.extensionIds.contains(extensionId);
    }

    public String toString() {
        return "Supported {extensions=" + this.extensions + ", protocol=" + 2 + "." + this.protocolMinor + "}";
    }
}

