/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.topology;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.topology.AbstractBucketTopology;
import com.couchbase.client.core.topology.BucketCapability;
import com.couchbase.client.core.topology.CouchbaseBucketTopology;
import com.couchbase.client.core.topology.HostAndServicePorts;
import com.couchbase.client.core.topology.JacksonHelper;
import com.couchbase.client.core.topology.PartitionMap;
import com.couchbase.client.core.topology.PartitionTopology;
import com.couchbase.client.core.util.CbCollections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jspecify.annotations.Nullable;

@Stability.Internal
class CouchbaseBucketTopologyParser {
    private static final TypeReference<List<List<Integer>>> LIST_OF_LIST_OF_INTEGER_TYPE = new TypeReference<List<List<Integer>>>(){};

    CouchbaseBucketTopologyParser() {
    }

    public static CouchbaseBucketTopology parse(ObjectNode configNode, List<HostAndServicePorts> nodes) {
        ObjectNode vBucketServerMap = (ObjectNode)configNode.get("vBucketServerMap");
        PartitionMap partitionMap = CouchbaseBucketTopologyParser.parsePartitionMap(nodes, vBucketServerMap.get("vBucketMap")).orElse(PartitionMap.ABSENT);
        Optional<PartitionMap> partitionMapForward = CouchbaseBucketTopologyParser.parsePartitionMap(nodes, vBucketServerMap.get("vBucketMapForward"));
        Set<BucketCapability> bucketCapabilities = AbstractBucketTopology.parseBucketCapabilities(configNode);
        boolean ephemeral = CouchbaseBucketTopologyParser.parseEphemeral(configNode, bucketCapabilities);
        return new CouchbaseBucketTopology(configNode.path("name").asText(), configNode.path("uuid").asText(), bucketCapabilities, nodes, ephemeral, vBucketServerMap.path("numReplicas").asInt(0), partitionMap, partitionMapForward.orElse(null));
    }

    private static boolean parseEphemeral(ObjectNode configNode, Set<BucketCapability> bucketCapabilities) {
        String bucketType = configNode.path("bucketType").textValue();
        return bucketType != null ? "ephemeral".equals(bucketType) : !bucketCapabilities.contains((Object)BucketCapability.COUCHAPI);
    }

    private static Optional<PartitionMap> parsePartitionMap(List<HostAndServicePorts> allNodes, @Nullable JsonNode vBucketMapNode) {
        if (vBucketMapNode == null) {
            return Optional.empty();
        }
        List<List<Integer>> vBucketMap = JacksonHelper.convertValue(vBucketMapNode, LIST_OF_LIST_OF_INTEGER_TYPE);
        List<PartitionTopology> entries = CbCollections.transform(vBucketMap, activeAndReplicaNodeIndexes -> PartitionTopology.parse(allNodes, activeAndReplicaNodeIndexes));
        return Optional.of(new PartitionMap(entries));
    }
}

