/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.topology;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.env.NetworkResolution;
import com.couchbase.client.core.topology.BucketTopology;
import com.couchbase.client.core.topology.ClusterCapability;
import com.couchbase.client.core.topology.ClusterIdentifier;
import com.couchbase.client.core.topology.ClusterTopologyWithBucket;
import com.couchbase.client.core.topology.HostAndServicePorts;
import com.couchbase.client.core.topology.PortSelector;
import com.couchbase.client.core.topology.TopologyRevision;
import com.couchbase.client.core.util.CbCollections;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;

@Stability.Internal
public class ClusterTopology {
    private final TopologyRevision revision;
    private final boolean tls;
    private final NetworkResolution network;
    private final Set<ClusterCapability> capabilities;
    private final List<HostAndServicePorts> nodes;
    private final @Nullable ClusterIdentifier clusterIdent;
    private final ObjectNode json;

    public static ClusterTopology of(ObjectNode json, TopologyRevision revision, @Nullable ClusterIdentifier clusterIdent, List<HostAndServicePorts> nodes, Set<ClusterCapability> capabilities, NetworkResolution network, PortSelector portSelector, @Nullable BucketTopology bucket) {
        if (bucket != null) {
            return new ClusterTopologyWithBucket(json, revision, nodes, capabilities, network, portSelector, bucket, clusterIdent);
        }
        return new ClusterTopology(json, revision, nodes, capabilities, network, portSelector, clusterIdent);
    }

    protected ClusterTopology(ObjectNode json, TopologyRevision revision, List<HostAndServicePorts> nodes, Set<ClusterCapability> capabilities, NetworkResolution network, PortSelector portSelector, @Nullable ClusterIdentifier clusterIdent) {
        if (network.equals(NetworkResolution.AUTO)) {
            throw new IllegalArgumentException("Must resolve 'auto' network before creating config.");
        }
        this.json = Objects.requireNonNull(json);
        this.revision = Objects.requireNonNull(revision);
        this.nodes = CbCollections.listCopyOf(nodes);
        this.capabilities = Collections.unmodifiableSet(CbCollections.newEnumSet(ClusterCapability.class, capabilities));
        this.network = Objects.requireNonNull(network);
        this.tls = Objects.requireNonNull(portSelector) == PortSelector.TLS;
        this.clusterIdent = clusterIdent;
    }

    public ObjectNode json() {
        return this.json;
    }

    public TopologyRevision revision() {
        return this.revision;
    }

    public List<HostAndServicePorts> nodes() {
        return this.nodes;
    }

    public NetworkResolution network() {
        return this.network;
    }

    public boolean hasCapability(ClusterCapability capability) {
        return this.capabilities.contains((Object)capability);
    }

    public Set<ClusterCapability> capabilities() {
        return this.capabilities;
    }

    public boolean isTls() {
        return this.tls;
    }

    public ClusterTopologyWithBucket requireBucket() {
        if (this instanceof ClusterTopologyWithBucket) {
            return (ClusterTopologyWithBucket)this;
        }
        throw new NoSuchElementException("Bucket topology is absent.");
    }

    public @Nullable ClusterIdentifier id() {
        return this.clusterIdent;
    }

    public String toString() {
        String bucket = this instanceof ClusterTopologyWithBucket ? this.requireBucket().bucket().toString() : "<N/A>";
        return this.getClass().getSimpleName() + "{revision=" + this.revision + ", clusterIdent=" + this.clusterIdent + ", tls=" + this.tls + ", network=" + this.network + ", capabilities=" + this.capabilities + ", nodes=" + this.nodes + ", bucket=" + bucket + '}';
    }
}

