/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.HostAndPort;
import java.util.Map;
import java.util.Optional;

public class ServiceContext
extends CoreContext {
    private final HostAndPort remote;
    private final ServiceType serviceType;
    private final Optional<String> bucket;

    public ServiceContext(CoreContext ctx, String remoteHostname, int remotePort, ServiceType serviceType, Optional<String> bucket) {
        super(ctx.core(), ctx.id(), ctx.environment(), ctx.authenticator());
        this.bucket = bucket;
        this.serviceType = serviceType;
        this.remote = new HostAndPort(remoteHostname, remotePort);
    }

    @Deprecated
    public String remoteHostname() {
        return this.remote.host();
    }

    @Deprecated
    public int remotePort() {
        return this.remote.port();
    }

    public HostAndPort remote() {
        return this.remote;
    }

    @Override
    public void injectExportableParams(Map<String, Object> input) {
        super.injectExportableParams(input);
        input.put("remote", this.remote.toString());
        input.put("type", (Object)this.serviceType);
        this.bucket.ifPresent(b -> input.put("bucket", b));
    }

    public ServiceType serviceType() {
        return this.serviceType;
    }

    public Optional<String> bucket() {
        return this.bucket;
    }
}

