/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar;

import com.couchbase.client.core.CoreResources;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.AbstractContext;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.util.CoreIdGenerator;
import java.util.Map;
import java.util.Objects;

@Stability.Internal
public final class ProtostellarContext
extends AbstractContext {
    private final long id = CoreIdGenerator.nextId();
    private final String hexId = String.format("0x%016x", this.id);
    private final CoreEnvironment env;
    private final Authenticator authenticator;
    private final CoreResources coreResources;

    public ProtostellarContext(CoreEnvironment env, Authenticator authenticator, CoreResources coreResources) {
        this.env = Objects.requireNonNull(env);
        this.authenticator = Objects.requireNonNull(authenticator);
        this.coreResources = Objects.requireNonNull(coreResources);
    }

    public long id() {
        return this.id;
    }

    public String hexId() {
        return this.hexId;
    }

    public CoreEnvironment environment() {
        return this.env;
    }

    public CoreResources coreResources() {
        return this.coreResources;
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    @Override
    public void injectExportableParams(Map<String, Object> input) {
        input.put("coreId", this.hexId);
    }
}

