/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreSubdocGetCommand;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.buffer.CompositeByteBuf;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.msg.kv.SubDocumentField;
import com.couchbase.client.core.msg.kv.SubDocumentOpResponseStatus;
import com.couchbase.client.core.msg.kv.SubdocCommandType;
import com.couchbase.client.core.msg.kv.SubdocGetResponse;
import com.couchbase.client.core.msg.kv.SubdocUtil;
import com.couchbase.client.core.retry.RetryStrategy;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class SubdocGetRequest
extends BaseKeyValueRequest<SubdocGetResponse> {
    private static final byte SUBDOC_FLAG_XATTR_PATH = 4;
    private static final byte SUBDOC_FLAG_BINARY_VALUE = 32;
    private static final Comparator<Command> xattrsFirst = Comparator.comparing(it -> !it.xattr());
    private final byte flags;
    private final List<Command> commands;
    private final String origKey;

    public static SubdocGetRequest create(Duration timeout, CoreContext ctx, CollectionIdentifier collectionIdentifier, RetryStrategy retryStrategy, String key, byte flags, List<CoreSubdocGetCommand> commands, RequestSpan span) {
        return new SubdocGetRequest(timeout, ctx, collectionIdentifier, retryStrategy, key, flags, SubdocGetRequest.convertCommands(commands), span);
    }

    public SubdocGetRequest(Duration timeout, CoreContext ctx, CollectionIdentifier collectionIdentifier, RetryStrategy retryStrategy, String key, byte flags, List<Command> commands, RequestSpan span) {
        super(timeout, ctx, retryStrategy, key, collectionIdentifier, span);
        this.flags = flags;
        this.commands = commands;
        this.origKey = key;
        if (span != null) {
            span.lowCardinalityAttribute("db.operation", "lookup_in");
        }
    }

    static List<Command> convertCommands(List<CoreSubdocGetCommand> commands) {
        ArrayList<Command> result = new ArrayList<Command>(commands.size());
        int len = commands.size();
        for (int i = 0; i < len; ++i) {
            CoreSubdocGetCommand core = commands.get(i);
            result.add(new Command(core.type(), core.path(), core.xattr(), core.binary(), i));
        }
        result.sort(xattrsFirst);
        return result;
    }

    @Stability.Internal
    public static List<CoreSubdocGetCommand> convertCommandsToCore(List<Command> commands) {
        ArrayList<CoreSubdocGetCommand> result = new ArrayList<CoreSubdocGetCommand>(commands.size());
        for (Command cmd : commands) {
            result.add(new CoreSubdocGetCommand(cmd.type, cmd.path, cmd.xattr, cmd.binary));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        ByteBuf byteBuf;
        ByteBuf key = null;
        ByteBuf extras = null;
        ByteBuf body = null;
        try {
            if (!ctx.vattrEnabled()) {
                for (Command c : this.commands) {
                    if (!c.xattr() || c.path.length() <= 0 || c.path.charAt(0) != '$' || c.path.startsWith("$document") || c.path.startsWith("$XTOC")) continue;
                    throw MemcacheProtocol.mapSubDocumentError(this, SubDocumentOpResponseStatus.XATTR_UNKNOWN_VATTR, c.path, c.originalIndex(), null);
                }
            }
            key = this.encodedKeyWithCollection(alloc, ctx);
            if (this.flags != 0) {
                extras = alloc.buffer(1).writeByte(this.flags);
            }
            if (this.commands.size() == 1) {
                body = this.commands.get(0).encode(alloc, ctx.subdocBinaryXattr());
            } else {
                body = alloc.compositeBuffer(this.commands.size());
                for (Command command : this.commands) {
                    ByteBuf commandBuffer = command.encode(alloc, ctx.subdocBinaryXattr());
                    try {
                        ((CompositeByteBuf)body).addComponent(commandBuffer);
                        body.writerIndex(body.writerIndex() + commandBuffer.readableBytes());
                    }
                    catch (Exception ex) {
                        ReferenceCountUtil.release(commandBuffer);
                        throw ex;
                    }
                }
            }
            byteBuf = MemcacheProtocol.request(alloc, MemcacheProtocol.Opcode.SUBDOC_MULTI_LOOKUP, MemcacheProtocol.noDatatype(), this.partition(), opaque, MemcacheProtocol.noCas(), extras == null ? MemcacheProtocol.noExtras() : extras, key, body);
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(key);
            ReferenceCountUtil.release(body);
            ReferenceCountUtil.release(extras);
            throw throwable;
        }
        ReferenceCountUtil.release(key);
        ReferenceCountUtil.release(body);
        ReferenceCountUtil.release(extras);
        return byteBuf;
    }

    @Override
    public SubdocGetResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        CouchbaseException nonFieldError;
        boolean isDeleted;
        boolean isSuccess;
        short rawStatus = MemcacheProtocol.status(response);
        boolean isJson = (MemcacheProtocol.datatype(response) & MemcacheProtocol.Datatype.JSON.datatype()) != 0;
        Optional<ByteBuf> maybeBody = MemcacheProtocol.body(response);
        MemcacheProtocol.FlexibleExtras flexibleExtras = MemcacheProtocol.flexibleExtras(response);
        ResponseStatus status = MemcacheProtocol.decodeStatus(response);
        SubDocumentField[] values = null;
        ArrayList<CouchbaseException> errors = null;
        Optional<CouchbaseException> error = Optional.empty();
        String bodyErrorMessage = null;
        boolean bl = isSuccess = rawStatus == MemcacheProtocol.Status.SUCCESS.status() || rawStatus == MemcacheProtocol.Status.SUBDOC_SUCCESS_DELETED_DOCUMENT.status() || rawStatus == MemcacheProtocol.Status.SUBDOC_MULTI_PATH_FAILURE.status() || rawStatus == MemcacheProtocol.Status.SUBDOC_MULTI_PATH_FAILURE_DELETED.status();
        if (maybeBody.isPresent()) {
            ByteBuf body = maybeBody.get();
            if (isSuccess) {
                values = new SubDocumentField[this.commands.size()];
                for (Command command : this.commands) {
                    SubDocumentField op;
                    short statusRaw = body.readShort();
                    SubDocumentOpResponseStatus fieldStatus = MemcacheProtocol.decodeSubDocumentStatus(statusRaw);
                    Optional<CouchbaseException> fieldError = Optional.empty();
                    if (fieldStatus != SubDocumentOpResponseStatus.SUCCESS) {
                        if (errors == null) {
                            errors = new ArrayList<CouchbaseException>();
                        }
                        CouchbaseException err = MemcacheProtocol.mapSubDocumentError(this, fieldStatus, command.path, command.originalIndex(), flexibleExtras);
                        errors.add(err);
                        fieldError = Optional.of(err);
                    }
                    int valueLength = body.readInt();
                    byte[] value = new byte[valueLength];
                    body.readBytes(value, 0, valueLength);
                    values[((Command)command).originalIndex] = op = new SubDocumentField(fieldStatus, fieldError, value, command.path, command.type);
                }
            } else if (isJson) {
                byte[] value = new byte[body.readableBytes()];
                body.readBytes(value, 0, body.readableBytes());
                bodyErrorMessage = new String(value, StandardCharsets.UTF_8);
            }
        }
        boolean bl2 = isDeleted = rawStatus == MemcacheProtocol.Status.SUBDOC_MULTI_PATH_FAILURE_DELETED.status() || rawStatus == MemcacheProtocol.Status.SUBDOC_SUCCESS_DELETED_DOCUMENT.status();
        if (rawStatus == MemcacheProtocol.Status.SUBDOC_MULTI_PATH_FAILURE.status() || rawStatus == MemcacheProtocol.Status.SUBDOC_MULTI_PATH_FAILURE_DELETED.status()) {
            status = this.commands.size() == 1 && this.commands.get(0).type == SubdocCommandType.EXISTS ? ResponseStatus.SUCCESS : ResponseStatus.SUCCESS;
        }
        if ((nonFieldError = SubdocUtil.handleNonFieldLevelErrors(this, rawStatus, flexibleExtras, bodyErrorMessage)) != null) {
            error = Optional.of(nonFieldError);
        }
        return new SubdocGetResponse(status, error, values, MemcacheProtocol.cas(response), isDeleted, flexibleExtras);
    }

    @Override
    public boolean idempotent() {
        return true;
    }

    @Override
    public String name() {
        return "lookup_in";
    }

    public static class Command {
        private final SubdocCommandType type;
        private final String path;
        private final boolean xattr;
        private final int originalIndex;
        private final boolean binary;

        public Command(SubdocCommandType type, String path, boolean xattr, int originalIndex) {
            this(type, path, xattr, false, originalIndex);
        }

        public Command(SubdocCommandType type, String path, boolean xattr, boolean binary, int originalIndex) {
            this.type = type;
            this.path = path;
            this.xattr = xattr;
            this.originalIndex = originalIndex;
            this.binary = binary;
        }

        public ByteBuf encode(ByteBufAllocator alloc, boolean binarySupported) {
            byte[] path = this.path.getBytes(StandardCharsets.UTF_8);
            int pathLength = path.length;
            ByteBuf buffer = alloc.buffer(4 + pathLength);
            buffer.writeByte(this.type.opcode());
            int flags = 0;
            if (this.xattr) {
                flags = (byte)(flags | 4);
            }
            if (this.binary && binarySupported) {
                flags = (byte)(flags | 0x20);
            }
            buffer.writeByte(flags);
            buffer.writeShort(pathLength);
            buffer.writeBytes(path);
            return buffer;
        }

        public int originalIndex() {
            return this.originalIndex;
        }

        public boolean xattr() {
            return this.xattr;
        }
    }
}

