/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.kv.CoreRangeScanId;
import com.couchbase.client.core.kv.CoreScanOptions;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.PredeterminedPartitionRequest;
import com.couchbase.client.core.msg.kv.RangeScanCancelResponse;

@Stability.Internal
public class RangeScanCancelRequest
extends PredeterminedPartitionRequest<RangeScanCancelResponse> {
    private final CoreRangeScanId id;

    public RangeScanCancelRequest(CoreRangeScanId id, CoreScanOptions options, short partition, CoreContext ctx, CollectionIdentifier collectionIdentifier) {
        super(partition, options.commonOptions().timeout().orElse(ctx.environment().timeoutConfig().kvScanTimeout()), ctx, options.commonOptions().retryStrategy().orElse(ctx.environment().retryStrategy()), null, collectionIdentifier, ctx.coreResources().requestTracer().requestSpan("range_scan_cancel", options.commonOptions().parentSpan().orElse(null)));
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        ByteBuf extras = alloc.buffer(this.id.bytes().length);
        try {
            extras.writeBytes(this.id.bytes());
            ByteBuf byteBuf = MemcacheProtocol.request(alloc, MemcacheProtocol.Opcode.RANGE_SCAN_CANCEL, MemcacheProtocol.noDatatype(), this.partition(), opaque, MemcacheProtocol.noCas(), extras, MemcacheProtocol.noKey(), MemcacheProtocol.noBody());
            return byteBuf;
        }
        finally {
            extras.release();
        }
    }

    @Override
    public RangeScanCancelResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        ResponseStatus status = MemcacheProtocol.decodeStatus(response);
        return new RangeScanCancelResponse(status);
    }
}

