/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.apptelemetry.collector;

import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.CbCollections;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

enum AppTelemetryRequestType {
    KV_RETRIEVAL(ServiceType.KV, Duration.ofMillis(1L), Duration.ofMillis(10L), Duration.ofMillis(100L), Duration.ofMillis(500L), Duration.ofMillis(1000L), Duration.ofMillis(2500L)),
    KV_MUTATION_NONDURABLE(ServiceType.KV, AppTelemetryRequestType.KV_RETRIEVAL.buckets),
    KV_MUTATION_DURABLE(ServiceType.KV, Duration.ofMillis(10L), Duration.ofMillis(100L), Duration.ofMillis(500L), Duration.ofSeconds(1L), Duration.ofSeconds(2L), Duration.ofSeconds(10L)),
    QUERY(ServiceType.QUERY, Duration.ofMillis(100L), Duration.ofSeconds(1L), Duration.ofSeconds(10L), Duration.ofSeconds(30L), Duration.ofSeconds(75L)),
    SEARCH(ServiceType.SEARCH, AppTelemetryRequestType.QUERY.buckets),
    ANALYTICS(ServiceType.ANALYTICS, AppTelemetryRequestType.QUERY.buckets),
    EVENTING(ServiceType.EVENTING, AppTelemetryRequestType.QUERY.buckets),
    MANAGEMENT(ServiceType.MANAGER, AppTelemetryRequestType.QUERY.buckets);

    static final List<AppTelemetryRequestType> valueList;
    final ServiceType service;
    final String name;
    final List<Duration> buckets;

    private AppTelemetryRequestType(ServiceType service, Duration ... buckets) {
        this(service, Arrays.asList(buckets));
    }

    private AppTelemetryRequestType(ServiceType service, List<Duration> buckets) {
        this.service = Objects.requireNonNull(service);
        this.buckets = CbCollections.listCopyOf(buckets);
        this.name = "sdk_" + this.name().toLowerCase(Locale.ROOT);
    }

    static {
        valueList = CbCollections.listOf(AppTelemetryRequestType.values());
    }
}

