/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.apptelemetry.collector;

import com.couchbase.client.core.cnc.apptelemetry.collector.AppTelemetryCounter;
import com.couchbase.client.core.cnc.apptelemetry.collector.AppTelemetryCounterType;
import com.couchbase.client.core.cnc.apptelemetry.collector.AppTelemetryHistogram;
import com.couchbase.client.core.cnc.apptelemetry.collector.AppTelemetryRequestType;
import com.couchbase.client.core.cnc.apptelemetry.collector.Reportable;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.CbCollections;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

class AppTelemetryMetricSet {
    private static final List<ServiceType> trackedServices = CbCollections.listOf(ServiceType.KV, ServiceType.QUERY, ServiceType.SEARCH, ServiceType.ANALYTICS, ServiceType.EVENTING, ServiceType.MANAGER);
    final Map<AppTelemetryRequestType, AppTelemetryHistogram> histograms;
    final Map<ServiceType, Map<AppTelemetryCounterType, AppTelemetryCounter>> counters;

    AppTelemetryMetricSet() {
        EnumMap tempHistograms = new EnumMap(AppTelemetryRequestType.class);
        AppTelemetryRequestType.valueList.forEach(type -> tempHistograms.put((AppTelemetryRequestType)((Object)type), new AppTelemetryHistogram((AppTelemetryRequestType)((Object)type))));
        this.histograms = Collections.unmodifiableMap(tempHistograms);
        EnumMap tempCounters = new EnumMap(ServiceType.class);
        trackedServices.forEach(service -> tempCounters.put((ServiceType)((Object)service), AppTelemetryMetricSet.newCounters(service)));
        this.counters = Collections.unmodifiableMap(tempCounters);
    }

    private static Map<AppTelemetryCounterType, AppTelemetryCounter> newCounters(ServiceType serviceType) {
        EnumMap map = new EnumMap(AppTelemetryCounterType.class);
        AppTelemetryCounterType.valueList.forEach(resolution -> map.put((AppTelemetryCounterType)((Object)resolution), new AppTelemetryCounter(serviceType, (AppTelemetryCounterType)((Object)resolution))));
        return Collections.unmodifiableMap(map);
    }

    void forEachMetric(Consumer<Reportable> action) {
        this.histograms.values().forEach(action);
        this.counters.values().forEach(it -> it.values().forEach(action));
    }
}

