/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.classic.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.query.CoreQueryMetrics;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonProcessingException;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.TreeNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.util.Golang;
import com.couchbase.client.core.util.Validators;
import java.io.IOException;
import java.time.Duration;
import java.util.Optional;

@Stability.Internal
public class ClassicCoreQueryMetrics
implements CoreQueryMetrics {
    private final Duration elapsedTime;
    private final Duration executionTime;
    private final long sortCount;
    private final long resultCount;
    private final long resultSize;
    private final long mutationCount;
    private final long errorCount;
    private final long warningCount;

    public ClassicCoreQueryMetrics(byte[] raw) {
        Validators.notNull(raw, "raw");
        try {
            JsonNode rootNode = Mapper.reader().readTree(raw);
            this.elapsedTime = this.decode(rootNode, String.class, "elapsedTime").map(Golang::parseDuration).orElse(Duration.ZERO);
            this.executionTime = this.decode(rootNode, String.class, "executionTime").map(Golang::parseDuration).orElse(Duration.ZERO);
            this.sortCount = this.decode(rootNode, Long.class, "sortCount").orElse(0L);
            this.resultCount = this.decode(rootNode, Long.class, "resultCount").orElse(0L);
            this.resultSize = this.decode(rootNode, Long.class, "resultSize").orElse(0L);
            this.mutationCount = this.decode(rootNode, Long.class, "mutationCount").orElse(0L);
            this.errorCount = this.decode(rootNode, Long.class, "errorCount").orElse(0L);
            this.warningCount = this.decode(rootNode, Long.class, "warningCount").orElse(0L);
        }
        catch (IOException e) {
            throw new DecodingFailureException("Could not decode query metrics");
        }
    }

    @Override
    public Duration elapsedTime() {
        return this.elapsedTime;
    }

    @Override
    public Duration executionTime() {
        return this.executionTime;
    }

    @Override
    public long sortCount() {
        return this.sortCount;
    }

    @Override
    public long resultCount() {
        return this.resultCount;
    }

    @Override
    public long resultSize() {
        return this.resultSize;
    }

    @Override
    public long mutationCount() {
        return this.mutationCount;
    }

    @Override
    public long errorCount() {
        return this.errorCount;
    }

    @Override
    public long warningCount() {
        return this.warningCount;
    }

    private <T> Optional<T> decode(JsonNode rootNode, Class<T> target, String path) {
        try {
            JsonNode subNode = rootNode.path(path);
            if (subNode == null || subNode.isNull() || subNode.isMissingNode()) {
                return Optional.empty();
            }
            return Optional.ofNullable(Mapper.reader().treeToValue((TreeNode)subNode, target));
        }
        catch (JsonProcessingException e) {
            throw new DecodingFailureException("Could not decode " + path + " in query metrics!");
        }
    }
}

