/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.queries;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.protostellar.search.v1.Query;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreCustomQuery
extends CoreSearchQuery {
    private final Map<String, Object> params;

    public CoreCustomQuery(Map<String, Object> customQuery, @Nullable Double boost) {
        super(boost);
        Validators.notNull(customQuery, "custom query");
        this.params = Collections.unmodifiableMap(new HashMap<String, Object>(customQuery));
    }

    @Override
    protected void injectParams(ObjectNode input) {
        ObjectNode obj = Mapper.convertValue(this.params, ObjectNode.class);
        obj.fields().forEachRemaining(field -> input.set((String)field.getKey(), (JsonNode)field.getValue()));
    }

    @Override
    public Query asProtostellar() {
        throw CoreProtostellarUtil.unsupportedInProtostellar("custom search queries");
    }
}

