/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.retry.RetryReason;
import com.couchbase.client.core.transaction.cleanup.CoreTransactionsCleanup;
import com.couchbase.client.core.transaction.components.CoreTransactionRequest;
import com.couchbase.client.core.transaction.config.CoreMergedTransactionConfig;
import com.couchbase.client.core.transaction.log.CoreTransactionLogger;
import com.couchbase.client.core.transaction.support.SpanWrapper;
import com.couchbase.client.core.transaction.support.SpanWrapperUtil;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreTransactionContext {
    private final long startTimeClient;
    public final CoreTransactionLogger LOGGER;
    private final String transactionId;
    private final SpanWrapper transactionSpan;
    private final CoreMergedTransactionConfig config;
    private final CoreTransactionsCleanup cleanup;
    private int numAttempts = 0;
    private final CoreTransactionRequest req;

    public CoreTransactionContext(CoreContext coreContext, String transactionId, CoreMergedTransactionConfig config, CoreTransactionsCleanup cleanup) {
        this.config = Objects.requireNonNull(config);
        this.cleanup = Objects.requireNonNull(cleanup);
        RequestTracer tracer = coreContext.environment().requestTracer();
        SpanWrapper pspan = config.parentSpan().map(sp -> new SpanWrapper((RequestSpan)sp)).orElse(null);
        this.transactionSpan = SpanWrapper.create(tracer, "transaction", pspan);
        SpanWrapperUtil.setAttributes(this.transactionSpan, null, null, null).attribute("db.operation", "transaction").attribute("db.couchbase.transaction.id", transactionId);
        this.req = new CoreTransactionRequest(config.expirationTime(), coreContext, this.transactionSpan.span());
        this.transactionId = Objects.requireNonNull(transactionId);
        this.startTimeClient = System.nanoTime();
        this.LOGGER = new CoreTransactionLogger(Objects.requireNonNull(coreContext.environment().eventBus()), transactionId);
    }

    public Duration expirationTime() {
        return this.config.expirationTime();
    }

    public long timeSinceStartOfTransactionsMillis(long now) {
        long expiredNanos = now - this.startTimeClient;
        return TimeUnit.NANOSECONDS.toMillis(expiredNanos);
    }

    public boolean hasExpiredClientSide() {
        boolean isExpired;
        long now = System.nanoTime();
        long expiredMillis = this.timeSinceStartOfTransactionsMillis(now);
        boolean bl = isExpired = expiredMillis > this.expirationTime().toMillis();
        if (isExpired) {
            this.LOGGER.info("Has expired client side (now=%dns start=%dns expired=%dmillis config=%dms)", now, this.startTimeClient, expiredMillis, this.expirationTime().toMillis());
        }
        return isExpired;
    }

    public String transactionId() {
        return this.transactionId;
    }

    public long startTimeClient() {
        return this.startTimeClient;
    }

    public SpanWrapper span() {
        return this.transactionSpan;
    }

    public int numAttempts() {
        return this.numAttempts;
    }

    public void incAttempts() {
        ++this.numAttempts;
    }

    public CoreTransactionsCleanup cleanup() {
        return this.cleanup;
    }

    public void incrementRetryAttempts(Duration lastRetryDuration, RetryReason reason) {
        this.req.context().incrementRetryAttempts(lastRetryDuration, reason);
    }

    public void finish(@Nullable Throwable err) {
        this.req.context().logicallyComplete(err);
    }
}

