/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.org.xbill.DNS;

import com.couchbase.client.core.deps.org.xbill.DNS.NioClient;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.time.temporal.ChronoUnit;

final class TCPClient {
    private final long startTime;
    private final Duration timeout;
    private final SelectionKey key;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TCPClient(Duration timeout) throws IOException {
        this.timeout = timeout;
        this.startTime = System.nanoTime();
        boolean done = false;
        Selector selector = null;
        SocketChannel channel = SocketChannel.open();
        try {
            selector = Selector.open();
            channel.configureBlocking(false);
            this.key = channel.register(selector, 1);
            done = true;
        }
        finally {
            if (!done && selector != null) {
                selector.close();
            }
            if (!done) {
                channel.close();
            }
        }
    }

    void bind(SocketAddress addr) throws IOException {
        SocketChannel channel = (SocketChannel)this.key.channel();
        channel.socket().bind(addr);
    }

    void connect(SocketAddress addr) throws IOException {
        SocketChannel channel = (SocketChannel)this.key.channel();
        if (channel.connect(addr)) {
            return;
        }
        this.key.interestOps(8);
        try {
            while (!channel.finishConnect()) {
                if (this.key.isConnectable()) continue;
                this.blockUntil(this.key);
            }
        }
        finally {
            if (this.key.isValid()) {
                this.key.interestOps(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(byte[] data) throws IOException {
        SocketChannel channel = (SocketChannel)this.key.channel();
        NioClient.verboseLog("TCP write", channel.socket().getLocalSocketAddress(), channel.socket().getRemoteSocketAddress(), data);
        byte[] lengthArray = new byte[]{(byte)(data.length >>> 8), (byte)(data.length & 0xFF)};
        ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.wrap(lengthArray), ByteBuffer.wrap(data)};
        int nsent = 0;
        this.key.interestOps(4);
        try {
            while (nsent < data.length + 2) {
                if (this.key.isWritable()) {
                    long n = channel.write(buffers);
                    if (n < 0L) {
                        throw new EOFException();
                    }
                    if ((nsent += (int)n) >= data.length + 2 || System.nanoTime() - this.startTime < this.timeout.toNanos()) continue;
                    throw new SocketTimeoutException();
                }
                this.blockUntil(this.key);
            }
        }
        finally {
            if (this.key.isValid()) {
                this.key.interestOps(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] _recv(int length) throws IOException {
        SocketChannel channel = (SocketChannel)this.key.channel();
        int nrecvd = 0;
        byte[] data = new byte[length];
        ByteBuffer buffer = ByteBuffer.wrap(data);
        this.key.interestOps(1);
        try {
            while (nrecvd < length) {
                if (this.key.isReadable()) {
                    long n = channel.read(buffer);
                    if (n < 0L) {
                        throw new EOFException();
                    }
                    if ((nrecvd += (int)n) >= length || System.nanoTime() - this.startTime < this.timeout.toNanos()) continue;
                    throw new SocketTimeoutException();
                }
                this.blockUntil(this.key);
            }
        }
        finally {
            if (this.key.isValid()) {
                this.key.interestOps(0);
            }
        }
        return data;
    }

    private void blockUntil(SelectionKey key) throws IOException {
        long remainingTimeout = this.timeout.minus(System.nanoTime() - this.startTime, ChronoUnit.NANOS).toMillis();
        int nkeys = 0;
        if (remainingTimeout > 0L) {
            nkeys = key.selector().select(remainingTimeout);
        } else if (remainingTimeout == 0L) {
            nkeys = key.selector().selectNow();
        }
        if (nkeys == 0) {
            throw new SocketTimeoutException();
        }
    }

    void cleanup() throws IOException {
        this.key.selector().close();
        this.key.channel().close();
    }

    byte[] recv() throws IOException {
        byte[] buf = this._recv(2);
        int length = ((buf[0] & 0xFF) << 8) + (buf[1] & 0xFF);
        byte[] data = this._recv(length);
        SocketChannel channel = (SocketChannel)this.key.channel();
        NioClient.verboseLog("TCP read", channel.socket().getLocalSocketAddress(), channel.socket().getRemoteSocketAddress(), data);
        return data;
    }
}

