/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.org.xbill.DNS;

import com.couchbase.client.core.deps.org.xbill.DNS.Name;
import com.couchbase.client.core.deps.org.xbill.DNS.config.AndroidResolverConfigProvider;
import com.couchbase.client.core.deps.org.xbill.DNS.config.FallbackPropertyResolverConfigProvider;
import com.couchbase.client.core.deps.org.xbill.DNS.config.InitializationException;
import com.couchbase.client.core.deps.org.xbill.DNS.config.JndiContextResolverConfigProvider;
import com.couchbase.client.core.deps.org.xbill.DNS.config.PropertyResolverConfigProvider;
import com.couchbase.client.core.deps.org.xbill.DNS.config.ResolvConfResolverConfigProvider;
import com.couchbase.client.core.deps.org.xbill.DNS.config.ResolverConfigProvider;
import com.couchbase.client.core.deps.org.xbill.DNS.config.SunJvmResolverConfigProvider;
import com.couchbase.client.core.deps.org.xbill.DNS.config.WindowsResolverConfigProvider;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResolverConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResolverConfig.class);
    public static final String CONFIGPROVIDER_SKIP_INIT = "dnsjava.configprovider.skipinit";
    private final List<InetSocketAddress> servers = new ArrayList<InetSocketAddress>(2);
    private final List<Name> searchlist = new ArrayList<Name>(0);
    private int ndots = 1;
    private static ResolverConfig currentConfig;
    private static List<ResolverConfigProvider> configProviders;

    private static void checkInitialized() {
        if (currentConfig == null || configProviders == null) {
            ResolverConfig.refresh();
        }
    }

    public static synchronized ResolverConfig getCurrentConfig() {
        ResolverConfig.checkInitialized();
        return currentConfig;
    }

    public static synchronized List<ResolverConfigProvider> getConfigProviders() {
        ResolverConfig.checkInitialized();
        return Collections.unmodifiableList(configProviders);
    }

    public static synchronized void setConfigProviders(List<ResolverConfigProvider> providers) {
        configProviders = new ArrayList<ResolverConfigProvider>(providers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh() {
        ResolverConfig newConfig = new ResolverConfig();
        Class<ResolverConfig> clazz = ResolverConfig.class;
        synchronized (ResolverConfig.class) {
            currentConfig = newConfig;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolverConfig() {
        Class<ResolverConfig> clazz = ResolverConfig.class;
        synchronized (ResolverConfig.class) {
            if (configProviders == null) {
                configProviders = new ArrayList<ResolverConfigProvider>(8);
                if (!Boolean.getBoolean(CONFIGPROVIDER_SKIP_INIT)) {
                    configProviders.add(new PropertyResolverConfigProvider());
                    configProviders.add(new ResolvConfResolverConfigProvider());
                    configProviders.add(new WindowsResolverConfigProvider());
                    configProviders.add(new AndroidResolverConfigProvider());
                    configProviders.add(new JndiContextResolverConfigProvider());
                    configProviders.add(new SunJvmResolverConfigProvider());
                    configProviders.add(new FallbackPropertyResolverConfigProvider());
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            for (ResolverConfigProvider provider : configProviders) {
                if (!provider.isEnabled()) continue;
                try {
                    List<Name> lsearchPaths;
                    provider.initialize();
                    if (this.servers.isEmpty()) {
                        this.servers.addAll(provider.servers());
                    }
                    if (this.searchlist.isEmpty() && !(lsearchPaths = provider.searchPaths()).isEmpty()) {
                        this.searchlist.addAll(lsearchPaths);
                        this.ndots = provider.ndots();
                    }
                    if (this.servers.isEmpty() || this.searchlist.isEmpty()) continue;
                    return;
                }
                catch (InitializationException e) {
                    log.warn("Failed to initialize provider", (Throwable)e);
                }
            }
            if (this.servers.isEmpty()) {
                this.servers.add(new InetSocketAddress(InetAddress.getLoopbackAddress(), 53));
            }
            return;
        }
    }

    public List<InetSocketAddress> servers() {
        return this.servers;
    }

    public InetSocketAddress server() {
        return this.servers.get(0);
    }

    public List<Name> searchPath() {
        return this.searchlist;
    }

    public int ndots() {
        return this.ndots;
    }
}

