/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.config.AbstractBucketConfig;
import com.couchbase.client.core.config.BucketCapabilities;
import com.couchbase.client.core.config.BucketNodeLocator;
import com.couchbase.client.core.config.BucketType;
import com.couchbase.client.core.config.ClusterCapabilities;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.config.Partition;
import com.couchbase.client.core.config.PartitionInfo;
import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JacksonInject;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.core.error.ConfigException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.service.ServiceType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CouchbaseBucketConfig
extends AbstractBucketConfig {
    public static final int PARTITION_NOT_EXISTENT = -2;
    private final PartitionInfo partitionInfo;
    private final List<NodeInfo> partitionHosts;
    private final Set<String> nodesWithPrimaryPartitions;
    private final boolean tainted;
    private final boolean ephemeral;

    @JsonCreator
    public CouchbaseBucketConfig(@JsonProperty(value="rev") long rev, @JsonProperty(value="revEpoch") long revEpoch, @JsonProperty(value="uuid") String uuid, @JsonProperty(value="name") String name, @JsonProperty(value="uri") String uri, @JsonProperty(value="streamingUri") String streamingUri, @JsonProperty(value="vBucketServerMap") PartitionInfo partitionInfo, @JsonProperty(value="nodes") List<NodeInfo> nodeInfos, @JsonProperty(value="nodesExt") List<PortInfo> portInfos, @JsonProperty(value="bucketCapabilities") List<BucketCapabilities> bucketCapabilities, @JsonProperty(value="clusterCapabilities") Map<String, Set<ClusterCapabilities>> clusterCapabilities, @JsonProperty(value="bucketType") BucketType bucketType, @JacksonInject(value="origin") String origin) {
        super(uuid, name, BucketNodeLocator.VBUCKET, uri, streamingUri, nodeInfos, portInfos, bucketCapabilities, origin, clusterCapabilities, rev, revEpoch);
        this.partitionInfo = partitionInfo;
        this.tainted = partitionInfo.tainted();
        List<NodeInfo> extendedNodeInfos = this.nodes();
        this.partitionHosts = CouchbaseBucketConfig.buildPartitionHosts(extendedNodeInfos, partitionInfo);
        this.nodesWithPrimaryPartitions = CouchbaseBucketConfig.buildNodesWithPrimaryPartitions(nodeInfos, partitionInfo.partitions());
        this.ephemeral = bucketType != null ? BucketType.EPHEMERAL == bucketType : bucketCapabilities != null && !bucketCapabilities.contains((Object)BucketCapabilities.COUCHAPI);
    }

    private static Set<String> buildNodesWithPrimaryPartitions(List<NodeInfo> nodeInfos, List<Partition> partitions) {
        HashSet<String> nodes = new HashSet<String>(nodeInfos.size());
        for (Partition partition : partitions) {
            short index = partition.active();
            if (index < 0) continue;
            nodes.add(nodeInfos.get(index).hostname());
        }
        return nodes;
    }

    private static List<NodeInfo> buildPartitionHosts(List<NodeInfo> nodeInfos, PartitionInfo partitionInfo) {
        ArrayList<NodeInfo> partitionHosts = new ArrayList<NodeInfo>();
        for (String rawHost : partitionInfo.partitionHosts()) {
            String convertedHost;
            try {
                String[] parts = rawHost.split(":");
                String host = "";
                if (parts.length > 2) {
                    for (int i = 0; i < parts.length - 1; ++i) {
                        host = host + parts[i];
                        if (parts[i].endsWith("]")) break;
                        host = host + ":";
                    }
                    if (host.startsWith("[") && host.endsWith("]")) {
                        host = host.substring(1, host.length() - 1);
                    }
                    if (host.endsWith(":")) {
                        host = host.substring(0, host.length() - 1);
                    }
                } else {
                    host = parts[0];
                }
                convertedHost = host;
            }
            catch (Exception e) {
                throw new ConfigException("Could not resolve " + rawHost + "on config building.", e);
            }
            for (NodeInfo nodeInfo : nodeInfos) {
                boolean hostMatches;
                boolean directPortEnabled = nodeInfo.services().containsKey((Object)ServiceType.KV);
                boolean sslPortEnabled = nodeInfo.sslServices().containsKey((Object)ServiceType.KV);
                if (!directPortEnabled && !sslPortEnabled || !(hostMatches = nodeInfo.hostname().equals(convertedHost)) || partitionHosts.contains(nodeInfo)) continue;
                partitionHosts.add(nodeInfo);
            }
        }
        if (partitionHosts.size() != partitionInfo.partitionHosts().length) {
            throw new ConfigException("Partition size is not equal after conversion, this is a bug.");
        }
        return partitionHosts;
    }

    public int numberOfReplicas() {
        return this.partitionInfo.numberOfReplicas();
    }

    @Override
    public boolean tainted() {
        return this.tainted;
    }

    public boolean hasPrimaryPartitionsOnNode(String hostname) {
        return this.nodesWithPrimaryPartitions.contains(hostname);
    }

    public short nodeIndexForActive(int partition, boolean useFastForward) {
        if (useFastForward && !this.hasFastForwardMap()) {
            throw new IllegalStateException("Could not get index from FF-Map, none found in this config.");
        }
        List<Partition> partitions = useFastForward ? this.partitionInfo.forwardPartitions() : this.partitionInfo.partitions();
        try {
            return partitions.get(partition).active();
        }
        catch (IndexOutOfBoundsException ex) {
            return -2;
        }
    }

    public short nodeIndexForReplica(int partition, int replica, boolean useFastForward) {
        if (useFastForward && !this.hasFastForwardMap()) {
            throw new IllegalStateException("Could not get index from FF-Map, none found in this config.");
        }
        List<Partition> partitions = useFastForward ? this.partitionInfo.forwardPartitions() : this.partitionInfo.partitions();
        try {
            return partitions.get(partition).replica(replica);
        }
        catch (IndexOutOfBoundsException ex) {
            return -2;
        }
    }

    public int numberOfPartitions() {
        return this.partitionInfo.partitions().size();
    }

    public NodeInfo nodeAtIndex(int nodeIndex) {
        return this.partitionHosts.get(nodeIndex);
    }

    @Override
    public BucketType type() {
        return BucketType.COUCHBASE;
    }

    @Override
    public boolean hasFastForwardMap() {
        return this.partitionInfo.hasFastForwardMap();
    }

    public boolean ephemeral() {
        return this.ephemeral;
    }

    public String toString() {
        return "CouchbaseBucketConfig{name='" + RedactableArgument.redactMeta(this.name()) + '\'' + ", locator=" + (Object)((Object)this.locator()) + ", uri='" + RedactableArgument.redactMeta(this.uri()) + '\'' + ", streamingUri='" + RedactableArgument.redactMeta(this.streamingUri()) + '\'' + ", nodes=" + RedactableArgument.redactSystem(this.nodes()) + ", partitionInfo=" + this.partitionInfo + ", tainted=" + this.tainted + ", version=" + this.version() + '}';
    }
}

