/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.CoreProtostellar;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreKvBinaryOps;
import com.couchbase.client.core.api.kv.CoreKvOps;
import com.couchbase.client.core.api.manager.CoreBucketAndScope;
import com.couchbase.client.core.api.manager.search.CoreSearchIndexManager;
import com.couchbase.client.core.api.query.CoreQueryOps;
import com.couchbase.client.core.api.search.CoreSearchOps;
import com.couchbase.client.core.diagnostics.ClusterState;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.manager.CoreBucketManagerOps;
import com.couchbase.client.core.manager.CoreCollectionManager;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.ConnectionString;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

@Stability.Internal
public interface CoreCouchbaseOps {
    public CoreKvOps kvOps(CoreKeyspace var1);

    public CoreKvBinaryOps kvBinaryOps(CoreKeyspace var1);

    public CoreQueryOps queryOps();

    public CoreSearchOps searchOps(@Nullable CoreBucketAndScope var1);

    public CoreBucketManagerOps bucketManager();

    public CoreCollectionManager collectionManager(String var1);

    public CoreSearchIndexManager clusterSearchIndexManager();

    public CoreSearchIndexManager scopeSearchIndexManager(CoreBucketAndScope var1);

    public CoreEnvironment environment();

    public CompletableFuture<Void> waitUntilReady(Set<ServiceType> var1, Duration var2, ClusterState var3, @Nullable String var4);

    public Mono<Void> shutdown(Duration var1);

    public static CoreCouchbaseOps create(CoreEnvironment env, Authenticator authenticator, ConnectionString connectionString) {
        switch (connectionString.scheme()) {
            case COUCHBASE2: {
                return new CoreProtostellar(env, authenticator, connectionString);
            }
            case COUCHBASE: 
            case COUCHBASES: {
                return Core.create(env, authenticator, connectionString);
            }
        }
        throw InvalidArgumentException.fromMessage("Unrecognized connection string scheme: " + (Object)((Object)connectionString.scheme()));
    }

    public static void checkConnectionStringScheme(ConnectionString cs, ConnectionString.Scheme ... validSchemes) {
        Set<ConnectionString.Scheme> set = CbCollections.setOf(validSchemes);
        if (!set.contains((Object)cs.scheme())) {
            throw new IllegalArgumentException("Expected connection string scheme to be one of " + set + " but got: " + (Object)((Object)cs.scheme()));
        }
    }

    @Deprecated
    default public Core asCore() {
        if (!(this instanceof Core)) {
            throw new FeatureNotAvailableException("Not yet supported when using couchbase2 protocol.");
        }
        return (Core)this;
    }
}

