/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar.manager;

import com.couchbase.client.core.CoreProtostellar;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreDurability;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.manager.collection.CoreCreateOrUpdateCollectionSettings;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.protostellar.ProtostellarCollectionManagerRequest;
import com.couchbase.client.core.protostellar.ProtostellarRequest;
import com.couchbase.client.protostellar.admin.collection.v1.CreateCollectionRequest;
import com.couchbase.client.protostellar.admin.collection.v1.CreateScopeRequest;
import com.couchbase.client.protostellar.admin.collection.v1.DeleteCollectionRequest;
import com.couchbase.client.protostellar.admin.collection.v1.DeleteScopeRequest;
import com.couchbase.client.protostellar.admin.collection.v1.ListCollectionsRequest;
import java.time.Duration;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreProtostellarCollectionManagerRequests {
    private CoreProtostellarCollectionManagerRequests() {
    }

    public static ProtostellarRequest<CreateCollectionRequest> createCollectionRequest(CoreProtostellar core, String bucketName, String scopeName, String collectionName, @Nullable CoreCreateOrUpdateCollectionSettings settings, CoreCommonOptions opts) {
        Duration timeout = CoreProtostellarUtil.managementTimeout(opts.timeout(), core);
        CreateCollectionRequest.Builder request = CreateCollectionRequest.newBuilder().setBucketName(bucketName).setScopeName(scopeName).setCollectionName(collectionName);
        if (settings != null) {
            if (settings.maxExpiry() != null) {
                request.setMaxExpirySecs(Math.toIntExact(settings.maxExpiry().getSeconds()));
            }
            if (settings.history() != null) {
                throw CoreProtostellarUtil.unsupportedCurrentlyInProtostellar();
            }
        }
        return new ProtostellarCollectionManagerRequest<CreateCollectionRequest>(request.build(), core, bucketName, scopeName, collectionName, "manager_collections_create_collection", CoreProtostellarUtil.createSpan(core, "manager_collections_create_collection", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
    }

    public static ProtostellarRequest<DeleteCollectionRequest> deleteCollectionRequest(CoreProtostellar core, String bucketName, String scopeName, String collectionName, CoreCommonOptions opts) {
        Duration timeout = CoreProtostellarUtil.managementTimeout(opts.timeout(), core);
        DeleteCollectionRequest request = DeleteCollectionRequest.newBuilder().setBucketName(bucketName).setScopeName(scopeName).setCollectionName(collectionName).build();
        return new ProtostellarCollectionManagerRequest<DeleteCollectionRequest>(request, core, bucketName, scopeName, collectionName, "manager_collections_drop_collection", CoreProtostellarUtil.createSpan(core, "manager_collections_drop_collection", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
    }

    public static ProtostellarRequest<CreateScopeRequest> createScopeRequest(CoreProtostellar core, String bucketName, String scopeName, CoreCommonOptions opts) {
        Duration timeout = CoreProtostellarUtil.managementTimeout(opts.timeout(), core);
        CreateScopeRequest request = CreateScopeRequest.newBuilder().setBucketName(bucketName).setScopeName(scopeName).build();
        return new ProtostellarCollectionManagerRequest<CreateScopeRequest>(request, core, bucketName, scopeName, null, "manager_collections_create_scope", CoreProtostellarUtil.createSpan(core, "manager_collections_create_scope", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
    }

    public static ProtostellarRequest<DeleteScopeRequest> deleteScopeRequest(CoreProtostellar core, String bucketName, String scopeName, CoreCommonOptions opts) {
        Duration timeout = CoreProtostellarUtil.managementTimeout(opts.timeout(), core);
        DeleteScopeRequest request = DeleteScopeRequest.newBuilder().setBucketName(bucketName).setScopeName(scopeName).build();
        return new ProtostellarCollectionManagerRequest<DeleteScopeRequest>(request, core, bucketName, scopeName, null, "manager_collections_drop_scope", CoreProtostellarUtil.createSpan(core, "manager_collections_drop_scope", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
    }

    public static ProtostellarRequest<ListCollectionsRequest> listCollectionsRequest(CoreProtostellar core, String bucketName, CoreCommonOptions opts) {
        Duration timeout = CoreProtostellarUtil.managementTimeout(opts.timeout(), core);
        ListCollectionsRequest request = ListCollectionsRequest.newBuilder().setBucketName(bucketName).build();
        return new ProtostellarCollectionManagerRequest<ListCollectionsRequest>(request, core, bucketName, null, null, "manager_collections_get_all_scopes", CoreProtostellarUtil.createSpan(core, "manager_collections_get_all_scopes", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, true, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
    }
}

