/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.manager;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.endpoint.http.CoreHttpClient;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.endpoint.http.CoreHttpResponse;
import com.couchbase.client.core.msg.RequestTarget;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import java.util.concurrent.CompletableFuture;

@Stability.Internal
public class CoreEventingFunctionManager {
    private static final String V1 = "/api/v1";
    private final Core core;
    private final CoreHttpClient httpClient;

    public CoreEventingFunctionManager(Core core) {
        this.core = core;
        this.httpClient = core.httpClient(RequestTarget.eventing());
    }

    private static String pathForFunctions() {
        return "/api/v1/functions";
    }

    private static String pathForFunction(String name) {
        return CoreEventingFunctionManager.pathForFunctions() + "/" + UrlQueryStringBuilder.urlEncode(name);
    }

    private static String pathForDeploy(String name) {
        return CoreEventingFunctionManager.pathForFunction(name) + "/deploy";
    }

    private static String pathForUndeploy(String name) {
        return CoreEventingFunctionManager.pathForFunction(name) + "/undeploy";
    }

    private static String pathForResume(String name) {
        return CoreEventingFunctionManager.pathForFunction(name) + "/resume";
    }

    private static String pathForPause(String name) {
        return CoreEventingFunctionManager.pathForFunction(name) + "/pause";
    }

    private static String pathForStatus() {
        return "/api/v1/status";
    }

    public CompletableFuture<Void> upsertFunction(String name, byte[] function, CoreCommonOptions options) {
        return this.httpClient.post(CoreHttpPath.path(CoreEventingFunctionManager.pathForFunction(name)), options).json(function).trace("manager_eventing_upsert_function").build().exec(this.core).thenApply(response -> null);
    }

    public CompletableFuture<Void> dropFunction(String name, CoreCommonOptions options) {
        return this.httpClient.delete(CoreHttpPath.path(CoreEventingFunctionManager.pathForFunction(name)), options).trace("manager_eventing_drop_function").build().exec(this.core).thenApply(response -> null);
    }

    public CompletableFuture<Void> deployFunction(String name, CoreCommonOptions options) {
        return this.httpClient.post(CoreHttpPath.path(CoreEventingFunctionManager.pathForDeploy(name)), options).trace("manager_eventing_deploy_function").build().exec(this.core).thenApply(response -> null);
    }

    public CompletableFuture<byte[]> getAllFunctions(CoreCommonOptions options) {
        return this.httpClient.get(CoreHttpPath.path(CoreEventingFunctionManager.pathForFunctions()), options).trace("manager_eventing_get_all_functions").build().exec(this.core).thenApply(CoreHttpResponse::content);
    }

    public CompletableFuture<byte[]> getFunction(String name, CoreCommonOptions options) {
        return this.httpClient.get(CoreHttpPath.path(CoreEventingFunctionManager.pathForFunction(name)), options).trace("manager_eventing_get_function").build().exec(this.core).thenApply(CoreHttpResponse::content);
    }

    public CompletableFuture<Void> pauseFunction(String name, CoreCommonOptions options) {
        return this.httpClient.post(CoreHttpPath.path(CoreEventingFunctionManager.pathForPause(name)), options).trace("manager_eventing_pause_function").build().exec(this.core).thenApply(response -> null);
    }

    public CompletableFuture<Void> resumeFunction(String name, CoreCommonOptions options) {
        return this.httpClient.post(CoreHttpPath.path(CoreEventingFunctionManager.pathForResume(name)), options).trace("manager_eventing_resume_function").build().exec(this.core).thenApply(response -> null);
    }

    public CompletableFuture<Void> undeployFunction(String name, CoreCommonOptions options) {
        return this.httpClient.post(CoreHttpPath.path(CoreEventingFunctionManager.pathForUndeploy(name)), options).trace("manager_eventing_undeploy_function").build().exec(this.core).thenApply(response -> null);
    }

    public CompletableFuture<byte[]> functionsStatus(CoreCommonOptions options) {
        return this.httpClient.get(CoreHttpPath.path(CoreEventingFunctionManager.pathForStatus()), options).trace("manager_eventing_functions_status").build().exec(this.core).thenApply(CoreHttpResponse::content);
    }
}

