/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.protostellar.ProtostellarStatsCollector;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;

@Stability.Internal
public class CouchbaseForkPoolThreadFactory
implements ForkJoinPool.ForkJoinWorkerThreadFactory {
    public static ProtostellarStatsCollector collector;
    private final String namePrefix;
    private final AtomicInteger threadNumber = new AtomicInteger();

    public CouchbaseForkPoolThreadFactory(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    @Override
    public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
        CouchbaseThread t = new CouchbaseThread(pool);
        t.setName(this.namePrefix + this.threadNumber.getAndIncrement());
        t.setDaemon(true);
        if (collector != null) {
            collector.currentMaxThreadCount(pool.getActiveThreadCount());
        }
        return t;
    }

    static class CouchbaseThread
    extends ForkJoinWorkerThread {
        public CouchbaseThread(ForkJoinPool pool) {
            super(pool);
        }
    }
}

