/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.org.xbill.DNS;

import com.couchbase.client.core.deps.org.xbill.DNS.Compression;
import com.couchbase.client.core.deps.org.xbill.DNS.DNAMERecord;
import com.couchbase.client.core.deps.org.xbill.DNS.DNSInput;
import com.couchbase.client.core.deps.org.xbill.DNS.DNSOutput;
import com.couchbase.client.core.deps.org.xbill.DNS.NameTooLongException;
import com.couchbase.client.core.deps.org.xbill.DNS.TextParseException;
import com.couchbase.client.core.deps.org.xbill.DNS.WireParseException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Name
implements Comparable<Name>,
Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Name.class);
    private static final long serialVersionUID = -6036624806201621219L;
    private static final int LABEL_NORMAL = 0;
    private static final int LABEL_COMPRESSION = 192;
    private static final int LABEL_MASK = 192;
    private byte[] name;
    private long offsets;
    private transient int hashcode;
    private int labels;
    private static final byte[] emptyLabel = new byte[]{0};
    private static final byte[] wildLabel = new byte[]{1, 42};
    public static final Name root;
    public static final Name empty;
    private static final int MAXNAME = 255;
    private static final int MAXLABEL = 63;
    private static final int MAXOFFSETS = 9;
    private static final byte[] lowercase;
    private static final Name wild;

    private Name() {
    }

    private void setoffset(int n, int offset) {
        if (n == 0 || n >= 9) {
            return;
        }
        int shift = 8 * (n - 1);
        this.offsets &= 255L << shift ^ 0xFFFFFFFFFFFFFFFFL;
        this.offsets |= (long)offset << shift;
    }

    private int offset(int n) {
        if (n == 0) {
            return 0;
        }
        if (n < 1 || n >= this.labels) {
            throw new IllegalArgumentException("label out of range");
        }
        if (n < 9) {
            int shift = 8 * (n - 1);
            return (int)(this.offsets >>> shift) & 0xFF;
        }
        int pos = (int)(this.offsets >>> 56) & 0xFF;
        for (int i = 8; i < n; ++i) {
            pos += this.name[pos] + 1;
        }
        return pos;
    }

    private static void copy(Name src, Name dst) {
        dst.name = src.name;
        dst.offsets = src.offsets;
        dst.labels = src.labels;
    }

    private void append(byte[] array, int arrayOffset, int numLabels) throws NameTooLongException {
        int length = this.name == null ? 0 : this.name.length;
        int appendLength = 0;
        int pos = arrayOffset;
        for (int i = 0; i < numLabels; ++i) {
            int len = array[pos] + 1;
            pos += len;
            appendLength += len;
        }
        int newlength = length + appendLength;
        if (newlength > 255) {
            throw new NameTooLongException();
        }
        byte[] newname = this.name != null ? Arrays.copyOf(this.name, newlength) : new byte[newlength];
        System.arraycopy(array, arrayOffset, newname, length, appendLength);
        this.name = newname;
        int pos2 = length;
        for (int i = 0; i < numLabels && i < 9; ++i) {
            this.setoffset(this.labels + i, pos2);
            pos2 += newname[pos2] + 1;
        }
        this.labels += numLabels;
    }

    private void append(char[] label, int len) throws NameTooLongException {
        int destPos = this.prepareAppend(len);
        for (int i = 0; i < len; ++i) {
            this.name[destPos + i] = (byte)label[i];
        }
    }

    private int prepareAppend(int len) throws NameTooLongException {
        int length = this.name == null ? 0 : this.name.length;
        int newlength = length + 1 + len;
        if (newlength > 255) {
            throw new NameTooLongException();
        }
        byte[] newname = this.name != null ? Arrays.copyOf(this.name, newlength) : new byte[newlength];
        newname[length] = (byte)len;
        this.name = newname;
        this.setoffset(this.labels, length);
        ++this.labels;
        return length + 1;
    }

    private void appendFromString(String fullName, char[] label, int length) throws TextParseException {
        try {
            this.append(label, length);
        }
        catch (NameTooLongException e) {
            throw new TextParseException(fullName, "Name too long", e);
        }
    }

    private void appendFromString(String fullName, byte[] label, int n) throws TextParseException {
        try {
            this.append(label, 0, n);
        }
        catch (NameTooLongException e) {
            throw new TextParseException(fullName, "Name too long");
        }
    }

    public Name(String s, Name origin) throws TextParseException {
        switch (s) {
            case "": {
                throw new TextParseException("empty name");
            }
            case "@": {
                if (origin == null) {
                    Name.copy(empty, this);
                } else {
                    Name.copy(origin, this);
                }
                return;
            }
            case ".": {
                Name.copy(root, this);
                return;
            }
        }
        int labelstart = -1;
        int pos = 0;
        char[] label = new char[63];
        boolean escaped = false;
        int digits = 0;
        int intval = 0;
        boolean absolute = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u00ff') {
                throw new TextParseException(s, "Illegal character in name");
            }
            if (escaped) {
                if (c >= '0' && c <= '9' && digits < 3) {
                    ++digits;
                    intval *= 10;
                    if ((intval += c - 48) > 255) {
                        throw new TextParseException(s, "bad escape");
                    }
                    if (digits < 3) continue;
                    c = (char)intval;
                } else if (digits > 0 && digits < 3) {
                    throw new TextParseException(s, "bad escape");
                }
                if (pos >= 63) {
                    throw new TextParseException(s, "label too long");
                }
                labelstart = pos;
                label[pos++] = c;
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                digits = 0;
                intval = 0;
                continue;
            }
            if (c == '.') {
                if (labelstart == -1) {
                    throw new TextParseException(s, "invalid empty label");
                }
                this.appendFromString(s, label, pos);
                labelstart = -1;
                pos = 0;
                continue;
            }
            if (labelstart == -1) {
                labelstart = i;
            }
            if (pos >= 63) {
                throw new TextParseException(s, "label too long");
            }
            label[pos++] = c;
        }
        if (digits > 0 && digits < 3 || escaped) {
            throw new TextParseException(s, "bad escape");
        }
        if (labelstart == -1) {
            this.appendFromString(s, emptyLabel, 1);
            absolute = true;
        } else {
            this.appendFromString(s, label, pos);
        }
        if (origin != null && !absolute) {
            this.appendFromString(s, origin.name, origin.labels);
        }
        if (!absolute && this.length() == 255) {
            throw new TextParseException(s, "Name too long");
        }
    }

    public Name(String s) throws TextParseException {
        this(s, null);
    }

    public static Name fromString(String s, Name origin) throws TextParseException {
        if (s.equals("@")) {
            return origin != null ? origin : empty;
        }
        if (s.equals(".")) {
            return root;
        }
        return new Name(s, origin);
    }

    public static Name fromString(String s) throws TextParseException {
        return Name.fromString(s, null);
    }

    public static Name fromConstantString(String s) {
        try {
            return Name.fromString(s, null);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException("Invalid name '" + s + "'");
        }
    }

    public Name(DNSInput in) throws WireParseException {
        boolean done = false;
        byte[] label = new byte[64];
        boolean savedState = false;
        block4: while (!done) {
            int len = in.readU8();
            switch (len & 0xC0) {
                case 0: {
                    if (len == 0) {
                        this.append(emptyLabel, 0, 1);
                        done = true;
                        continue block4;
                    }
                    label[0] = (byte)len;
                    in.readByteArray(label, 1, len);
                    this.append(label, 0, 1);
                    continue block4;
                }
                case 192: {
                    int pos = in.readU8();
                    log.trace("currently {}, pointer to {}", (Object)in.current(), (Object)(pos += (len & 0xFFFFFF3F) << 8));
                    if (pos >= in.current() - 2) {
                        throw new WireParseException("bad compression");
                    }
                    if (!savedState) {
                        in.save();
                        savedState = true;
                    }
                    in.jump(pos);
                    log.trace("current name '{}', seeking to {}", (Object)this, (Object)pos);
                    continue block4;
                }
            }
            throw new WireParseException("bad label type");
        }
        if (savedState) {
            in.restore();
        }
    }

    public Name(byte[] b) throws IOException {
        this(new DNSInput(b));
    }

    public Name(Name src, int n) {
        if (n > src.labels) {
            throw new IllegalArgumentException("attempted to remove too many labels");
        }
        if (n == src.labels) {
            Name.copy(empty, this);
            return;
        }
        this.labels = src.labels - n;
        this.name = Arrays.copyOfRange(src.name, src.offset(n), src.name.length);
        int strippedBytes = src.offset(n);
        for (int i = 1; i < 9 && i < this.labels; ++i) {
            this.setoffset(i, src.offset(i + n) - strippedBytes);
        }
    }

    public static Name concatenate(Name prefix, Name suffix) throws NameTooLongException {
        if (prefix.isAbsolute()) {
            return prefix;
        }
        Name newname = new Name();
        newname.append(prefix.name, 0, prefix.labels);
        newname.append(suffix.name, 0, suffix.labels);
        return newname;
    }

    public Name relativize(Name origin) {
        if (origin == null || !this.subdomain(origin)) {
            return this;
        }
        Name newname = new Name();
        int length = this.length() - origin.length();
        newname.labels = this.labels - origin.labels;
        newname.offsets = this.offsets;
        newname.name = new byte[length];
        System.arraycopy(this.name, 0, newname.name, 0, length);
        return newname;
    }

    public Name wild(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("must replace 1 or more labels");
        }
        try {
            Name newname = new Name();
            Name.copy(wild, newname);
            newname.append(this.name, this.offset(n), this.labels - n);
            return newname;
        }
        catch (NameTooLongException e) {
            throw new IllegalStateException("Name.wild: concatenate failed");
        }
    }

    public Name canonicalize() {
        boolean canonical = true;
        for (byte b : this.name) {
            if (lowercase[b & 0xFF] == b) continue;
            canonical = false;
            break;
        }
        if (canonical) {
            return this;
        }
        Name newname = new Name();
        newname.offsets = this.offsets;
        newname.labels = this.labels;
        newname.name = new byte[this.length()];
        for (int i = 0; i < newname.name.length; ++i) {
            newname.name[i] = lowercase[this.name[i] & 0xFF];
        }
        return newname;
    }

    public Name fromDNAME(DNAMERecord dname) throws NameTooLongException {
        Name dnameowner = dname.getName();
        Name dnametarget = dname.getTarget();
        if (!this.subdomain(dnameowner)) {
            return null;
        }
        int plabels = this.labels - dnameowner.labels;
        int plength = this.length() - dnameowner.length();
        int dlabels = dnametarget.labels;
        short dlength = dnametarget.length();
        if (plength + dlength > 255) {
            throw new NameTooLongException();
        }
        Name newname = new Name();
        newname.labels = plabels + dlabels;
        newname.name = Arrays.copyOf(this.name, plength + dlength);
        System.arraycopy(dnametarget.name, 0, newname.name, plength, dlength);
        int pos = 0;
        for (int i = 0; i < 9 && i < plabels + dlabels; ++i) {
            newname.setoffset(i, pos);
            pos += newname.name[pos] + 1;
        }
        return newname;
    }

    public boolean isWild() {
        if (this.labels == 0) {
            return false;
        }
        return this.name[0] == 1 && this.name[1] == 42;
    }

    public boolean isAbsolute() {
        if (this.labels == 0) {
            return false;
        }
        return this.name[this.offset(this.labels - 1)] == 0;
    }

    public short length() {
        if (this.labels == 0) {
            return 0;
        }
        return (short)this.name.length;
    }

    public int labels() {
        return this.labels;
    }

    public boolean subdomain(Name domain) {
        int dlabels = domain.labels;
        if (dlabels > this.labels) {
            return false;
        }
        if (dlabels == this.labels) {
            return this.equals(domain);
        }
        return domain.equals(this.name, this.offset(this.labels - dlabels));
    }

    private String byteString(byte[] array, int pos) {
        StringBuilder sb = new StringBuilder();
        byte len = array[pos++];
        for (int i = pos; i < pos + len; ++i) {
            int b = array[i] & 0xFF;
            if (b <= 32 || b >= 127) {
                sb.append('\\');
                if (b < 10) {
                    sb.append("00");
                } else if (b < 100) {
                    sb.append('0');
                }
                sb.append(b);
                continue;
            }
            if (b == 34 || b == 40 || b == 41 || b == 46 || b == 59 || b == 92 || b == 64 || b == 36) {
                sb.append('\\');
                sb.append((char)b);
                continue;
            }
            sb.append((char)b);
        }
        return sb.toString();
    }

    public String toString(boolean omitFinalDot) {
        if (this.labels == 0) {
            return "@";
        }
        if (this.labels == 1 && this.name[0] == 0) {
            return ".";
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        for (int label = 0; label < this.labels; ++label) {
            byte len = this.name[pos];
            if (len == 0) {
                if (omitFinalDot) break;
                sb.append('.');
                break;
            }
            if (label > 0) {
                sb.append('.');
            }
            sb.append(this.byteString(this.name, pos));
            pos += 1 + len;
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public byte[] getLabel(int n) {
        int pos = this.offset(n);
        byte len = (byte)(this.name[pos] + 1);
        return Arrays.copyOfRange(this.name, pos, pos + len);
    }

    public String getLabelString(int n) {
        int pos = this.offset(n);
        return this.byteString(this.name, pos);
    }

    public void toWire(DNSOutput out, Compression c) {
        if (!this.isAbsolute()) {
            throw new IllegalArgumentException("toWire() called on non-absolute name");
        }
        for (int i = 0; i < this.labels - 1; ++i) {
            Name tname = i == 0 ? this : new Name(this, i);
            int pos = -1;
            if (c != null) {
                pos = c.get(tname);
            }
            if (pos >= 0) {
                out.writeU16(pos |= 0xC000);
                return;
            }
            if (c != null) {
                c.add(out.current(), tname);
            }
            int off = this.offset(i);
            out.writeByteArray(this.name, off, this.name[off] + 1);
        }
        out.writeU8(0);
    }

    public byte[] toWire() {
        DNSOutput out = new DNSOutput();
        this.toWire(out, null);
        return out.toByteArray();
    }

    public void toWireCanonical(DNSOutput out) {
        byte[] b = this.toWireCanonical();
        out.writeByteArray(b);
    }

    public byte[] toWireCanonical() {
        if (this.labels == 0) {
            return new byte[0];
        }
        byte[] b = new byte[this.name.length];
        int spos = 0;
        int dpos = 0;
        for (int i = 0; i < this.labels; ++i) {
            int len = this.name[spos];
            b[dpos++] = this.name[spos++];
            for (int j = 0; j < len; ++j) {
                b[dpos++] = lowercase[this.name[spos++] & 0xFF];
            }
        }
        return b;
    }

    public void toWire(DNSOutput out, Compression c, boolean canonical) {
        if (canonical) {
            this.toWireCanonical(out);
        } else {
            this.toWire(out, c);
        }
    }

    private boolean equals(byte[] b, int bpos) {
        int pos = 0;
        for (int i = 0; i < this.labels; ++i) {
            if (this.name[pos] != b[bpos]) {
                return false;
            }
            int len = this.name[pos++];
            ++bpos;
            for (int j = 0; j < len; ++j) {
                if (lowercase[this.name[pos++] & 0xFF] == lowercase[b[bpos++] & 0xFF]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object arg) {
        if (arg == this) {
            return true;
        }
        if (!(arg instanceof Name)) {
            return false;
        }
        Name other = (Name)arg;
        if (other.labels != this.labels) {
            return false;
        }
        if (other.hashCode() != this.hashCode()) {
            return false;
        }
        return this.equals(other.name, 0);
    }

    public int hashCode() {
        if (this.hashcode != 0) {
            return this.hashcode;
        }
        int code = 0;
        for (int i = this.offset(0); i < this.name.length; ++i) {
            code += (code << 3) + (lowercase[this.name[i] & 0xFF] & 0xFF);
        }
        this.hashcode = code;
        return this.hashcode;
    }

    @Override
    public int compareTo(Name arg) {
        if (this == arg) {
            return 0;
        }
        int alabels = arg.labels;
        int compares = Math.min(this.labels, alabels);
        for (int i = 1; i <= compares; ++i) {
            int start = this.offset(this.labels - i);
            int astart = arg.offset(alabels - i);
            int length = this.name[start];
            byte alength = arg.name[astart];
            for (int j = 0; j < length && j < alength; ++j) {
                int n = (lowercase[this.name[j + start + 1] & 0xFF] & 0xFF) - (lowercase[arg.name[j + astart + 1] & 0xFF] & 0xFF);
                if (n == 0) continue;
                return n;
            }
            if (length == alength) continue;
            return length - alength;
        }
        return this.labels - alabels;
    }

    static {
        lowercase = new byte[256];
        for (int i = 0; i < lowercase.length; ++i) {
            Name.lowercase[i] = i < 65 || i > 90 ? (byte)i : (byte)(i - 65 + 97);
        }
        root = new Name();
        Name.root.name = emptyLabel;
        Name.root.labels = 1;
        empty = new Name();
        Name.empty.name = new byte[0];
        wild = new Name();
        Name.wild.name = wildLabel;
        Name.wild.labels = 1;
    }
}

