/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.InvalidArgumentException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CbCollections {
    private CbCollections() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static <E> List<E> listCopyOf(Collection<? extends E> original) {
        return CbCollections.listOf(original.toArray());
    }

    public static <E> Set<E> setCopyOf(Collection<? extends E> original) {
        return CbCollections.setOf(new HashSet<E>(original).toArray());
    }

    public static <K, V> Map<K, V> mapCopyOf(Map<? extends K, ? extends V> original) {
        HashMap result = new HashMap();
        original.forEach((k, v) -> CbCollections.putUniqueKey(result, k, v));
        return Collections.unmodifiableMap(result);
    }

    public static <T> List<T> copyToUnmodifiableList(@Nullable Collection<T> c) {
        return CbCollections.isNullOrEmpty(c) ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<T>(c));
    }

    public static <T> Set<T> copyToUnmodifiableSet(@Nullable Collection<T> c) {
        return CbCollections.isNullOrEmpty(c) ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<T>(c));
    }

    public static boolean isNullOrEmpty(@Nullable Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static boolean isNullOrEmpty(@Nullable Map<?, ?> m) {
        return m == null || m.isEmpty();
    }

    public static boolean isNullOrEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... items) {
        HashSet<T> result = new HashSet<T>();
        for (T item : items) {
            if (result.add(Objects.requireNonNull(item, "Set may not contain null"))) continue;
            throw InvalidArgumentException.fromMessage("Duplicate item: " + item);
        }
        return Collections.unmodifiableSet(result);
    }

    @SafeVarargs
    public static <T> List<T> listOf(T ... items) {
        ArrayList<T> result = new ArrayList<T>(items.length);
        for (T item : items) {
            result.add(Objects.requireNonNull(item, "List may not contain null"));
        }
        return Collections.unmodifiableList(result);
    }

    public static <K, V> Map<K, V> mapOf() {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1) {
        HashMap result = new HashMap();
        CbCollections.putUniqueKey(result, key1, value1);
        return Collections.unmodifiableMap(result);
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1, K key2, V value2) {
        HashMap result = new HashMap();
        CbCollections.putUniqueKey(result, key1, value1);
        CbCollections.putUniqueKey(result, key2, value2);
        return Collections.unmodifiableMap(result);
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1, K key2, V value2, K key3, V value3) {
        HashMap result = new HashMap();
        CbCollections.putUniqueKey(result, key1, value1);
        CbCollections.putUniqueKey(result, key2, value2);
        CbCollections.putUniqueKey(result, key3, value3);
        return Collections.unmodifiableMap(result);
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        HashMap result = new HashMap();
        CbCollections.putUniqueKey(result, key1, value1);
        CbCollections.putUniqueKey(result, key2, value2);
        CbCollections.putUniqueKey(result, key3, value3);
        CbCollections.putUniqueKey(result, key4, value4);
        return Collections.unmodifiableMap(result);
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5) {
        HashMap result = new HashMap();
        CbCollections.putUniqueKey(result, key1, value1);
        CbCollections.putUniqueKey(result, key2, value2);
        CbCollections.putUniqueKey(result, key3, value3);
        CbCollections.putUniqueKey(result, key4, value4);
        CbCollections.putUniqueKey(result, key5, value5);
        return Collections.unmodifiableMap(result);
    }

    private static <K, V> void putUniqueKey(Map<K, V> map, K key, V value) {
        Objects.requireNonNull(key, "Key may not be null.");
        Objects.requireNonNull(value, "Value may not be null.");
        if (map.put(key, value) != null) {
            throw InvalidArgumentException.fromMessage("Duplicate key: " + key);
        }
    }

    public static <T1, T2> List<T2> transform(Iterable<T1> input, Function<? super T1, ? extends T2> transformer) {
        ArrayList result = new ArrayList();
        input.forEach(it -> result.add(transformer.apply((Object)it)));
        return result;
    }

    public static <T1, T2> List<T2> transform(Iterator<T1> input, Function<? super T1, ? extends T2> transformer) {
        ArrayList result = new ArrayList();
        input.forEachRemaining(it -> result.add(transformer.apply((Object)it)));
        return result;
    }

    public static <T1, T2> List<T2> transform(T1[] input, Function<? super T1, ? extends T2> transformer) {
        return Arrays.stream(input).map(transformer).collect(Collectors.toList());
    }

    public static <T> List<T> filter(Iterable<T> input, Predicate<? super T> predicate) {
        ArrayList result = new ArrayList();
        input.forEach(it -> {
            if (predicate.test(it)) {
                result.add(it);
            }
        });
        return result;
    }

    public static <T> List<T> filter(T[] input, Predicate<? super T> predicate) {
        return Arrays.stream(input).filter(predicate).collect(Collectors.toList());
    }

    public static <K, V1, V2> Map<K, V2> transformValues(Map<K, V1> map, Function<V1, V2> transformer) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> transformer.apply(entry.getValue())));
    }

    public static <E> List<E> listCopyOf(Iterable<? extends E> original) {
        ArrayList result = new ArrayList();
        original.forEach(it -> result.add(Objects.requireNonNull(it, "List may not contain null.")));
        return Collections.unmodifiableList(result);
    }
}

