/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.query.CoreQueryMetaData;
import com.couchbase.client.core.api.query.CoreReactiveQueryResult;
import com.couchbase.client.core.msg.query.QueryChunkRow;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.protostellar.query.ProtostellarCoreQueryMetaData;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.protostellar.query.v1.QueryResponse;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Stability.Internal
public class ProtostellarCoreReactiveQueryResult
extends CoreReactiveQueryResult {
    private final Flux<QueryResponse> responses;

    public ProtostellarCoreReactiveQueryResult(Flux<QueryResponse> responses) {
        this.responses = Validators.notNull(responses, "responses");
    }

    @Override
    public Flux<QueryChunkRow> rows() {
        return this.responses.flatMap(response -> Flux.fromIterable(response.getRowsList()).map(row -> new QueryChunkRow(row.toByteArray())));
    }

    @Override
    public Mono<CoreQueryMetaData> metaData() {
        return this.responses.takeUntil(response -> response.hasMetaData()).single().map(response -> new ProtostellarCoreQueryMetaData(response.getMetaData()));
    }

    @Override
    public NodeIdentifier lastDispatchedTo() {
        return null;
    }
}

