/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.query.CoreQueryMetaData;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.msg.query.QueryChunkRow;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.protostellar.query.ProtostellarCoreQueryMetaData;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.protostellar.query.v1.QueryResponse;
import java.util.List;
import java.util.stream.Stream;

@Stability.Volatile
public class ProtostellarCoreQueryResult
extends CoreQueryResult {
    private final List<QueryResponse> responses;

    public ProtostellarCoreQueryResult(List<QueryResponse> responses) {
        this.responses = Validators.notNull(responses, "responses");
    }

    @Override
    public Stream<QueryChunkRow> rows() {
        return this.responses.stream().flatMap(response -> response.getRowsList().stream()).map(row -> new QueryChunkRow(row.toByteArray()));
    }

    @Override
    public CoreQueryMetaData metaData() {
        return this.responses.stream().filter(v -> v.hasMetaData()).map(v -> new ProtostellarCoreQueryMetaData(v.getMetaData())).findFirst().get();
    }

    @Override
    public NodeIdentifier lastDispatchedTo() {
        return null;
    }
}

