/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar.manager;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreDurability;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.protostellar.ProtostellarCollectionManagerRequest;
import com.couchbase.client.core.protostellar.ProtostellarRequest;
import com.couchbase.client.protostellar.admin.collection.v1.CreateCollectionRequest;
import com.couchbase.client.protostellar.admin.collection.v1.CreateScopeRequest;
import com.couchbase.client.protostellar.admin.collection.v1.DeleteCollectionRequest;
import com.couchbase.client.protostellar.admin.collection.v1.DeleteScopeRequest;
import com.couchbase.client.protostellar.admin.collection.v1.ListCollectionsRequest;
import java.time.Duration;

@Stability.Internal
public class CoreProtostellarCollectionManagerRequests {
    private CoreProtostellarCollectionManagerRequests() {
    }

    public static ProtostellarRequest<CreateCollectionRequest> createCollectionRequest(Core core, String bucketName, String scopeName, String collectionName, Duration maxTTL, CoreCommonOptions opts) {
        Duration timeout = CoreProtostellarUtil.managementTimeout(opts.timeout(), core);
        ProtostellarCollectionManagerRequest<CreateCollectionRequest> out = new ProtostellarCollectionManagerRequest<CreateCollectionRequest>(core, bucketName, scopeName, collectionName, "manager_collections_create_collection", CoreProtostellarUtil.createSpan(core, "manager_collections_create_collection", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
        CreateCollectionRequest.Builder request = CreateCollectionRequest.newBuilder().setBucketName(bucketName).setScopeName(scopeName).setCollectionName(collectionName);
        out.request(request.build());
        return out;
    }

    public static ProtostellarRequest<DeleteCollectionRequest> deleteCollectionRequest(Core core, String bucketName, String scopeName, String collectionName, CoreCommonOptions opts) {
        Duration timeout = CoreProtostellarUtil.managementTimeout(opts.timeout(), core);
        ProtostellarCollectionManagerRequest<DeleteCollectionRequest> out = new ProtostellarCollectionManagerRequest<DeleteCollectionRequest>(core, bucketName, scopeName, collectionName, "manager_collections_drop_collection", CoreProtostellarUtil.createSpan(core, "manager_collections_drop_collection", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
        DeleteCollectionRequest.Builder request = DeleteCollectionRequest.newBuilder().setBucketName(bucketName).setScopeName(scopeName).setCollectionName(collectionName);
        out.request(request.build());
        return out;
    }

    public static ProtostellarRequest<CreateScopeRequest> createScopeRequest(Core core, String bucketName, String scopeName, CoreCommonOptions opts) {
        Duration timeout = CoreProtostellarUtil.managementTimeout(opts.timeout(), core);
        ProtostellarCollectionManagerRequest<CreateScopeRequest> out = new ProtostellarCollectionManagerRequest<CreateScopeRequest>(core, bucketName, scopeName, null, "manager_collections_create_scope", CoreProtostellarUtil.createSpan(core, "manager_collections_create_scope", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
        CreateScopeRequest.Builder request = CreateScopeRequest.newBuilder().setBucketName(bucketName).setScopeName(scopeName);
        out.request(request.build());
        return out;
    }

    public static ProtostellarRequest<DeleteScopeRequest> deleteScopeRequest(Core core, String bucketName, String scopeName, CoreCommonOptions opts) {
        Duration timeout = CoreProtostellarUtil.managementTimeout(opts.timeout(), core);
        ProtostellarCollectionManagerRequest<DeleteScopeRequest> out = new ProtostellarCollectionManagerRequest<DeleteScopeRequest>(core, bucketName, scopeName, null, "manager_collections_drop_scope", CoreProtostellarUtil.createSpan(core, "manager_collections_drop_scope", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
        DeleteScopeRequest.Builder request = DeleteScopeRequest.newBuilder().setBucketName(bucketName).setScopeName(scopeName);
        out.request(request.build());
        return out;
    }

    public static ProtostellarRequest<ListCollectionsRequest> listCollectionsRequest(Core core, String bucketName, CoreCommonOptions opts) {
        Duration timeout = CoreProtostellarUtil.managementTimeout(opts.timeout(), core);
        ProtostellarCollectionManagerRequest<ListCollectionsRequest> out = new ProtostellarCollectionManagerRequest<ListCollectionsRequest>(core, bucketName, null, null, "manager_collections_get_all_scopes", CoreProtostellarUtil.createSpan(core, "manager_collections_get_all_scopes", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, true, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
        ListCollectionsRequest.Builder request = ListCollectionsRequest.newBuilder().setBucketName(bucketName);
        out.request(request.build());
        return out;
    }
}

